/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.admin.discovery.ReggieStat;
import com.gigaspaces.admin.ui.AdminUIThreadPool;
import com.gigaspaces.api.InternalApi;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;
import net.jini.discovery.DiscoveryEvent;
import net.jini.discovery.DiscoveryListener;

@InternalApi
public class RecordingDiscoveryListener
implements DiscoveryListener {
    private ArrayList discoveryTimes = new ArrayList();
    private static Logger LOGGER = Logger.getLogger(RecordingDiscoveryListener.class.getName());

    @Override
    public void discovered(final DiscoveryEvent dEvent) {
        Runnable discoveryProcess = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long t = System.currentTimeMillis();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(" --- BEGIN- discovered ");
                }
                Map groupsMap = dEvent.getGroups();
                Iterator groupsIterator = groupsMap.values().iterator();
                for (int i = 0; i < dEvent.getRegistrars().length; ++i) {
                    try {
                        String[] groups = (String[])groupsIterator.next();
                        ReggieStat rt = new ReggieStat(0, t, dEvent.getRegistrars()[i], groups);
                        ReggieStat existingStat = RecordingDiscoveryListener.this.getReggieStat(rt);
                        if (existingStat != null && existingStat.type == 1) {
                            rt.baseTime = existingStat.eventTime;
                        }
                        ArrayList arrayList = RecordingDiscoveryListener.this.discoveryTimes;
                        synchronized (arrayList) {
                            RecordingDiscoveryListener.this.discoveryTimes.add(rt);
                            continue;
                        }
                    }
                    catch (RemoteException e) {
                        if (!LOGGER.isLoggable(Level.INFO)) continue;
                        LOGGER.log(Level.INFO, "During recording discovery: " + e.toString(), e);
                    }
                }
                long endTime = System.currentTimeMillis();
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer(" --- Processing of discovering for event " + dEvent + " took " + (endTime - t) + " msec.");
                }
            }
        };
        AdminUIThreadPool.getThreadPool().execute(discoveryProcess);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void discarded(DiscoveryEvent dEvent) {
        long t = System.currentTimeMillis();
        ServiceRegistrar[] reggies = dEvent.getRegistrars();
        for (int i = 0; i < reggies.length; ++i) {
            ReggieStat rStat = this.removeReggieStat(reggies[i].getServiceID());
            if (rStat == null) continue;
            rStat.eventTime = t;
            rStat.type = 1;
            ArrayList arrayList = this.discoveryTimes;
            synchronized (arrayList) {
                this.discoveryTimes.add(rStat);
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReggieStat[] getReggieStats(int type) {
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("bad type");
        }
        ArrayList<ReggieStat> list = new ArrayList<ReggieStat>();
        ArrayList arrayList = this.discoveryTimes;
        synchronized (arrayList) {
            for (ReggieStat rt : this.discoveryTimes) {
                if (rt.type != type) continue;
                list.add(rt);
            }
        }
        return list.toArray(new ReggieStat[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReggieStat getReggieStat(ReggieStat reggieStat) {
        if (reggieStat == null) {
            throw new NullPointerException("reggieStat is null");
        }
        ReggieStat rStat = null;
        ArrayList arrayList = this.discoveryTimes;
        synchronized (arrayList) {
            for (ReggieStat rt : this.discoveryTimes) {
                if (!rt.machine.equals(reggieStat.machine) || rt.port != reggieStat.port || !rt.groupsMatch(reggieStat)) continue;
                rStat = rt;
                break;
            }
        }
        return rStat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReggieStat removeReggieStat(ServiceID id) {
        if (id == null) {
            throw new NullPointerException("id is null");
        }
        ReggieStat rStat = null;
        ArrayList arrayList = this.discoveryTimes;
        synchronized (arrayList) {
            for (ReggieStat rt : this.discoveryTimes) {
                if (!rt.serviceID.equals((Object)id)) continue;
                rStat = rt;
                this.discoveryTimes.remove(rt);
                break;
            }
        }
        return rStat;
    }
}

