/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.discovery;

import com.gigaspaces.api.InternalApi;
import java.rmi.RemoteException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceRegistrar;

@InternalApi
public class ReggieStat {
    long eventTime;
    long baseTime;
    String[] groups;
    String machine;
    int port;
    int type;
    ServiceID serviceID;
    public static final int DISCOVERED = 0;
    public static final int DISCARDED = 1;

    ReggieStat(int type, long t, ServiceRegistrar reggie, String[] groups) throws RemoteException {
        if (type < 0 || type > 1) {
            throw new IllegalArgumentException("bad type");
        }
        if (reggie == null) {
            throw new NullPointerException("reggie is null");
        }
        this.type = type;
        this.eventTime = t;
        this.groups = groups;
        LookupLocator locator = reggie.getLocator();
        this.machine = locator.getHost();
        this.port = locator.getPort();
        this.serviceID = reggie.getServiceID();
    }

    public long getBaseTime() {
        return this.baseTime;
    }

    public String getMachine() {
        return this.machine;
    }

    public int getPort() {
        return this.port;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    boolean groupsMatch(ReggieStat rStat) {
        if (rStat.groups == null && this.groups == null) {
            return true;
        }
        if (rStat.groups != null && this.groups == null) {
            return false;
        }
        if (rStat.groups == null && this.groups != null) {
            return false;
        }
        if (rStat.groups.length != this.groups.length) {
            return false;
        }
        for (int i = 0; i < rStat.groups.length; ++i) {
            boolean found = false;
            for (int j = 0; j < this.groups.length; ++j) {
                if (!this.groups[j].equals(rStat.groups[i])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

