/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.quiesce;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@InternalApi
public class InstancesQuiesceState
implements Externalizable {
    private static final long serialVersionUID = 7886735384418998738L;
    private Set<String> quiescedInstances = new HashSet<String>();
    private Map<String, Throwable> failedToQuiesceInstances = new HashMap<String, Throwable>();
    private Integer missingInstancesCount;

    public InstancesQuiesceState() {
    }

    public InstancesQuiesceState(Integer missing) {
        this.missingInstancesCount = missing;
    }

    public Map<String, Throwable> getFailedToQuiesceInstances() {
        return this.failedToQuiesceInstances;
    }

    public Set<String> getQuiescedInstances() {
        return this.quiescedInstances;
    }

    public void addQuiesced(String name) {
        this.quiescedInstances.add(name);
    }

    public void addFailure(String name, Throwable e) {
        this.failedToQuiesceInstances.put(name, e);
    }

    public Integer getMissingInstancesCount() {
        return this.missingInstancesCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstancesQuiesceState that = (InstancesQuiesceState)o;
        if (!this.failedToQuiesceInstances.equals(that.failedToQuiesceInstances)) {
            return false;
        }
        return this.quiescedInstances.equals(that.quiescedInstances);
    }

    public int hashCode() {
        int result = this.quiescedInstances.hashCode();
        result = 31 * result + this.failedToQuiesceInstances.hashCode();
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        IOUtils.writeStringSet(out, this.quiescedInstances);
        IOUtils.writeObject(out, this.failedToQuiesceInstances);
        IOUtils.writeObject(out, this.missingInstancesCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.quiescedInstances = IOUtils.readStringSet(in);
        this.failedToQuiesceInstances = (Map)IOUtils.readObject(in);
        this.missingInstancesCount = (Integer)IOUtils.readObject(in);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.quiescedInstances.size() > 0) {
            sb.append("Succeeded instances: [ ");
            Iterator<String> quiescedInstancesIterator = this.quiescedInstances.iterator();
            while (quiescedInstancesIterator.hasNext()) {
                sb.append(quiescedInstancesIterator.next());
                if (!quiescedInstancesIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
            sb.append('\n');
        }
        if (this.failedToQuiesceInstances.size() > 0) {
            sb.append("Failed instances: [ ");
            Iterator<String> failedToQuiesceInstancesIterator = this.failedToQuiesceInstances.keySet().iterator();
            while (failedToQuiesceInstancesIterator.hasNext()) {
                sb.append(failedToQuiesceInstancesIterator.next());
                if (!failedToQuiesceInstancesIterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
            sb.append('\n');
        }
        if (this.missingInstancesCount > 0) {
            sb.append("Missing number of instances: " + this.missingInstancesCount);
            sb.append('\n');
        }
        return sb.toString();
    }
}

