/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.admin.quiesce;

import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.IOUtils;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class QuiesceStateChangedEvent
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private QuiesceState quiesceState;
    private QuiesceToken token;
    private String description;

    public QuiesceStateChangedEvent() {
    }

    public QuiesceStateChangedEvent(QuiesceState quiesceState, QuiesceToken token, String description) {
        this.quiesceState = quiesceState;
        this.token = token;
        this.description = description;
    }

    public QuiesceState getQuiesceState() {
        return this.quiesceState;
    }

    public QuiesceToken getToken() {
        return this.token;
    }

    public String getDescription() {
        return this.description;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.quiesceState.getCode());
        IOUtils.writeObject(out, this.token);
        IOUtils.writeString(out, this.description);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int quiesceStateCode = in.readInt();
        this.quiesceState = QuiesceState.traslateCodeToState(quiesceStateCode);
        this.token = (QuiesceToken)IOUtils.readObject(in);
        this.description = IOUtils.readString(in);
    }
}

