/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.async;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.Executors;
import com.gigaspaces.async.internal.AbstractFuture;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;

@InternalApi
public class SettableFuture<T>
extends AbstractFuture<T> {
    private T result;
    private boolean hasValue;
    private Exception exception;
    private List<AsyncFutureListener<T>> listeners;
    private boolean canceled;
    private Executor executor;

    public SettableFuture(Executor executor) {
        this.executor = executor;
        this.listeners = new LinkedList<AsyncFutureListener<T>>();
    }

    public SettableFuture() {
        this(Executors.newDirectExecutor());
    }

    @Override
    protected T getResult() throws ExecutionException {
        this._lock.lock();
        try {
            if (this.hasValue) {
                T t = this.result;
                return t;
            }
            throw new ExecutionException(this.exception);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void setResult(Object result) {
        this._lock.lock();
        ArrayList<AsyncFutureListener<T>> listeners = new ArrayList<AsyncFutureListener<T>>(this.listeners);
        try {
            if (result instanceof Throwable) {
                this.exception = (Exception)result;
            } else {
                this.result = result;
                this.hasValue = true;
            }
            this._resultCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
        if (!listeners.isEmpty()) {
            DefaultAsyncResult<T> asyncRes = new DefaultAsyncResult<T>(this.result, this.exception);
            for (AsyncFutureListener asyncFutureListener : listeners) {
                this.fireEvent(asyncRes, asyncFutureListener);
            }
        }
    }

    private void fireEvent(final DefaultAsyncResult<T> asyncRes, final AsyncFutureListener<T> listener) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                listener.onResult(asyncRes);
            }
        });
    }

    @Override
    public void setListener(AsyncFutureListener<T> listener) {
        this._lock.lock();
        try {
            if (this.isDone()) {
                this.fireEvent(new DefaultAsyncResult<T>(this.result, this.exception), listener);
            }
            this.listeners.add(listener);
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.canceled = true;
        if (mayInterruptIfRunning && !this.isDone()) {
            try {
                this._lock.lock();
                this._resultCondition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        this._lock.lock();
        try {
            boolean bl = this.hasValue || this.exception != null;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    public String toString() {
        return "SettableFuture{result=" + this.result + ", hasValue=" + this.hasValue + ", exception=" + this.exception + ", canceled=" + this.canceled + '}';
    }
}

