/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.async.internal;

import com.gigaspaces.lrmi.nio.async.IFuture;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractFuture<T>
implements IFuture<T> {
    protected final Lock _lock = new ReentrantLock();
    protected final Condition _resultCondition = this._lock.newCondition();

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                T t = this.getResult();
                return t;
            }
            this._resultCondition.await();
            this.checkState();
            T t = this.getResult();
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                T t = this.getResult();
                return t;
            }
            if (!this._resultCondition.await(timeout, unit)) {
                throw new TimeoutException("Timeout waiting for result for [" + timeout + "]");
            }
            this.checkState();
            T t = this.getResult();
            return t;
        }
        finally {
            this._lock.unlock();
        }
    }

    protected abstract T getResult() throws ExecutionException;

    private void checkState() {
        if (this.isCancelled()) {
            throw new CancellationException("task was cancelled");
        }
    }
}

