/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.async.internal;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import com.gigaspaces.async.AsyncResultsReducer;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import com.gigaspaces.lrmi.nio.async.FutureContext;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

@InternalApi
public class CompoundFuture<T, R>
implements AsyncFuture<R>,
AsyncFutureListener<T> {
    private final List<AsyncResult<T>> replies;
    private volatile boolean canceled = false;
    private final int maxResults;
    private final AsyncResultsReducer<T, R> reducer;
    private final AsyncResultFilter<T> moderator;
    private final Lock _lock = new ReentrantLock();
    private final Condition _resultCondition = this._lock.newCondition();
    private volatile boolean done = false;
    private volatile AsyncFutureListener<R> listener;
    private int receivedResults = 0;

    public CompoundFuture(AsyncFuture<T>[] futures, AsyncResultsReducer<T, R> reducer) {
        this(futures, reducer, null);
    }

    public CompoundFuture(AsyncFuture<T>[] futures, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> moderator) {
        this.reducer = reducer;
        this.moderator = moderator;
        this.replies = new ArrayList<AsyncResult<T>>(futures.length);
        this.maxResults = futures.length;
        this.listener = FutureContext.getFutureListener();
        FutureContext.clear();
        for (AsyncFuture<T> future : futures) {
            future.setListener(this);
        }
    }

    @Override
    public void setListener(AsyncFutureListener<R> listener) {
        this.listener = listener;
        if (this.isCancelled() || this.isDone()) {
            Object result = null;
            Exception exp = null;
            try {
                result = this.getResult();
            }
            catch (ExecutionException e) {
                exp = (Exception)e.getCause();
            }
            listener.onResult(new DefaultAsyncResult<Object>(result, exp));
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        this.canceled = true;
        if (mayInterruptIfRunning && !this.isDone()) {
            try {
                this._lock.lock();
                this._resultCondition.signalAll();
            }
            finally {
                this._lock.unlock();
            }
        }
        return true;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    private AsyncResultFilter.Decision invokeAsyncResultFilter(AsyncResult<T> current) {
        if (this.moderator == null) {
            return AsyncResultFilter.Decision.CONTINUE;
        }
        AsyncResult[] asyncResults = this.replies.toArray(new AsyncResult[this.replies.size()]);
        AsyncResultFilterEvent<T> event = new AsyncResultFilterEvent<T>(current, asyncResults, this.maxResults);
        AsyncResultFilter.Decision decision = this.moderator.onResult(event);
        return decision;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                R r = this.getResult();
                return r;
            }
            this._resultCondition.await();
            this.checkState();
            R r = this.getResult();
            return r;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            this._lock.lock();
            this.checkState();
            if (this.isDone()) {
                R r = this.getResult();
                return r;
            }
            if (!this._resultCondition.await(timeout, unit)) {
                throw new TimeoutException("Timeout waiting for result for [" + timeout + "]");
            }
            this.checkState();
            R r = this.getResult();
            return r;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onResult(AsyncResult<T> result) {
        List<AsyncResult<T>> list = this.replies;
        synchronized (list) {
            if (this.done) {
                return;
            }
            ++this.receivedResults;
            boolean lastResult = this.receivedResults == this.maxResults;
            AsyncResultFilter.Decision decision = this.invokeAsyncResultFilter(result);
            switch (decision) {
                case CONTINUE: {
                    this.replies.add(result);
                    break;
                }
                case SKIP: {
                    break;
                }
                case BREAK: {
                    this.replies.add(result);
                    lastResult = true;
                    break;
                }
                case SKIP_AND_BREAK: {
                    lastResult = true;
                }
            }
            if (!lastResult) {
                return;
            }
            this.done = true;
        }
        try {
            this._lock.lock();
            this._resultCondition.signalAll();
        }
        finally {
            this._lock.unlock();
        }
        if (this.listener != null) {
            Object res = null;
            Exception exp = null;
            try {
                res = this.getResult();
            }
            catch (ExecutionException e) {
                exp = (Exception)e.getCause();
            }
            this.listener.onResult(new DefaultAsyncResult<Object>(res, exp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R getResult() throws ExecutionException {
        ArrayList res;
        List<AsyncResult<T>> list = this.replies;
        synchronized (list) {
            res = new ArrayList(this.replies.size());
            for (AsyncResult<T> replyPair : this.replies) {
                res.add(replyPair);
            }
        }
        try {
            return this.reducer.reduce(res);
        }
        catch (Exception e) {
            throw new ExecutionException(e);
        }
    }

    private void checkState() {
        if (this.isCancelled()) {
            throw new CancellationException("task was cancelled");
        }
    }
}

