/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.attribute_store;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.attribute_store.PropertiesHandler;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Properties;
import java.util.logging.Logger;

@InternalApi
public class PropertiesFileAttributeStore
implements AttributeStore,
Serializable {
    private static final long serialVersionUID = 1789885876431145300L;
    private static final Logger logger = Logger.getLogger(PropertiesFileAttributeStore.class.getName());
    private File file;

    public PropertiesFileAttributeStore() {
    }

    public PropertiesFileAttributeStore(String path) {
        this.file = new File(path);
        File directory = this.file.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        logger.info("PropertiesFileAttributeStore saved at " + directory.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String get(String key) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
        FileLock fileLock = fileChannel.lock();
        try {
            Properties p = this.readPropertiesFromChannel(fileChannel);
            String string = p.getProperty(key);
            return string;
        }
        finally {
            fileLock.release();
            fileChannel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String set(String key, String value) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
        FileLock fileLock = fileChannel.lock();
        String oldValue = null;
        try {
            Properties p = this.readPropertiesFromChannel(fileChannel);
            oldValue = (String)p.setProperty(key, value);
            this.writePropertiesToChannel(fileChannel, p);
        }
        finally {
            fileLock.release();
            fileChannel.close();
        }
        return oldValue;
    }

    @Override
    public void close() throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String remove(String name) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
        FileLock fileLock = fileChannel.lock();
        String oldValue = null;
        try {
            Properties p = this.readPropertiesFromChannel(fileChannel);
            oldValue = (String)p.remove(name);
            this.writePropertiesToChannel(fileChannel, p);
        }
        finally {
            fileLock.release();
            fileChannel.close();
        }
        return oldValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T withProperties(PropertiesHandler<T> propertiesHandler) throws IOException {
        FileChannel fileChannel = new RandomAccessFile(this.file, "rw").getChannel();
        FileLock fileLock = fileChannel.lock();
        T ret = null;
        try {
            Properties p = this.readPropertiesFromChannel(fileChannel);
            ret = propertiesHandler.handle(p);
            this.writePropertiesToChannel(fileChannel, p);
        }
        finally {
            fileLock.release();
            fileChannel.close();
        }
        return ret;
    }

    private Properties readPropertiesFromChannel(FileChannel fileChannel) throws IOException {
        int size = (int)fileChannel.size();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        while (0 < buffer.remaining()) {
            fileChannel.read(buffer);
        }
        Properties p = new Properties();
        p.load(new ByteArrayInputStream(buffer.array()));
        return p;
    }

    private void writePropertiesToChannel(FileChannel fileChannel, Properties p) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        p.store(os, null);
        byte[] byteArray = os.toByteArray();
        fileChannel.position(0L);
        ByteBuffer buffer = ByteBuffer.wrap(byteArray);
        while (0 < buffer.remaining()) {
            fileChannel.write(buffer);
        }
        fileChannel.truncate(byteArray.length);
    }
}

