/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.ChangedEntryDetails;
import com.gigaspaces.client.FailedChangedEntryDetails;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;

public class ChangeException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private Collection<ChangedEntryDetails<?>> _changedEntries;
    private int _numChangedEntries;
    private Collection<FailedChangedEntryDetails> _entriesFailedToChange;
    private Collection<Throwable> _errors;

    public ChangeException() {
    }

    public ChangeException(String message, Collection<ChangedEntryDetails<?>> changedEntries, Collection<FailedChangedEntryDetails> entriesFailedToChange, Collection<Throwable> errors) {
        super(message, ChangeException.initCause(errors, entriesFailedToChange));
        this._changedEntries = changedEntries;
        this._entriesFailedToChange = entriesFailedToChange;
        this._errors = errors;
        this._numChangedEntries = changedEntries.size();
    }

    public ChangeException(String message, int numChangedEntries, Collection<FailedChangedEntryDetails> entriesFailedToChange, Collection<Throwable> errors) {
        super(message, ChangeException.initCause(errors, entriesFailedToChange));
        this._numChangedEntries = numChangedEntries;
        this._entriesFailedToChange = entriesFailedToChange;
        this._errors = errors;
    }

    private static Throwable initCause(Collection<Throwable> errors, Collection<FailedChangedEntryDetails> entriesFailedToChange) {
        if (errors.size() + entriesFailedToChange.size() != 1) {
            return null;
        }
        if (!errors.isEmpty()) {
            return errors.iterator().next();
        }
        return entriesFailedToChange.iterator().next().getCause();
    }

    public Collection<ChangedEntryDetails<?>> getSuccesfullChanges() {
        return this._changedEntries;
    }

    public int getNumSuccesfullChanges() {
        return this._numChangedEntries;
    }

    public Collection<FailedChangedEntryDetails> getFailedChanges() {
        return this._entriesFailedToChange;
    }

    public Collection<Throwable> getErrors() {
        return this._errors;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            out.writeBoolean(this._changedEntries != null);
            if (this._changedEntries != null) {
                IOUtils.writeObject(out, this._changedEntries);
            } else {
                out.writeInt(this._numChangedEntries);
            }
        } else {
            IOUtils.writeObject(out, this._changedEntries);
        }
        IOUtils.writeObject(out, this._entriesFailedToChange);
        IOUtils.writeObject(out, this._errors);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            if (in.readBoolean()) {
                this._changedEntries = (Collection)IOUtils.readObject(in);
                this._numChangedEntries = this._changedEntries.size();
            } else {
                this._numChangedEntries = in.readInt();
            }
        } else {
            this._changedEntries = (Collection)IOUtils.readObject(in);
        }
        this._entriesFailedToChange = (Collection)IOUtils.readObject(in);
        this._errors = (Collection)IOUtils.readObject(in);
    }
}

