/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.ChangeFunction;
import com.gigaspaces.client.CustomChangeOperation;
import com.gigaspaces.client.mutators.SpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.AddAllToCollectionSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.AddToCollectionSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.IncrementSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.PutInMapSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.RemoveFromCollectionSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.RemoveFromMapSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.SetValueSpaceEntryMutator;
import com.gigaspaces.internal.client.mutators.UnsetValueSpaceEntryMutator;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.utils.Textualizable;
import com.gigaspaces.internal.utils.Textualizer;
import com.gigaspaces.server.MutableServerEntry;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

public class ChangeSet
implements Externalizable,
Textualizable {
    private static final long serialVersionUID = 1L;
    private final Collection<SpaceEntryMutator> _mutators;
    private long _lease;
    private transient Set<String> _nonCachedPaths = Collections.emptySet();

    public ChangeSet() {
        this._mutators = new LinkedList<SpaceEntryMutator>();
        this._lease = 0L;
    }

    ChangeSet(Collection<SpaceEntryMutator> mutators, long lease) {
        this._mutators = mutators;
        this._lease = lease;
    }

    private ChangeSet add(SpaceEntryMutator mutator) {
        this._mutators.add(mutator);
        return this;
    }

    public boolean isEmpty() {
        return this._mutators.isEmpty() && this._lease == 0L;
    }

    public ChangeSet custom(SpaceEntryMutator changeOperation) {
        return this.add(changeOperation);
    }

    public ChangeSet custom(String name, ChangeFunction<MutableServerEntry, Object> operation) {
        return this.custom(CustomChangeOperation.from(name, operation));
    }

    public ChangeSet set(String path, Serializable value) {
        return this.add(new SetValueSpaceEntryMutator(path, value));
    }

    public ChangeSet unset(String path) {
        return this.add(new UnsetValueSpaceEntryMutator(path));
    }

    public ChangeSet increment(String path, byte delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet increment(String path, short delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet increment(String path, int delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet increment(String path, long delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet increment(String path, float delta) {
        return this.add(new IncrementSpaceEntryMutator(path, Float.valueOf(delta)));
    }

    public ChangeSet increment(String path, double delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet increment(String path, Number delta) {
        return this.add(new IncrementSpaceEntryMutator(path, delta));
    }

    public ChangeSet decrement(String path, byte delta) {
        return this.increment(path, (int)(-delta));
    }

    public ChangeSet decrement(String path, short delta) {
        return this.increment(path, (int)(-delta));
    }

    public ChangeSet decrement(String path, int delta) {
        return this.increment(path, -delta);
    }

    public ChangeSet decrement(String path, long delta) {
        return this.increment(path, -delta);
    }

    public ChangeSet decrement(String path, float delta) {
        return this.increment(path, -delta);
    }

    public ChangeSet decrement(String path, double delta) {
        return this.increment(path, -delta);
    }

    public ChangeSet addToCollection(String path, Serializable newItem) {
        return this.add(new AddToCollectionSpaceEntryMutator(path, newItem));
    }

    public ChangeSet addAllToCollection(String path, Serializable ... newItems) {
        return this.addAllToCollection(path, Arrays.asList(newItems));
    }

    public ChangeSet addAllToCollection(String path, Collection<? extends Serializable> newItems) {
        return this.add(new AddAllToCollectionSpaceEntryMutator(path, newItems));
    }

    public ChangeSet removeFromCollection(String path, Serializable itemToRemove) {
        return this.add(new RemoveFromCollectionSpaceEntryMutator(path, itemToRemove));
    }

    public ChangeSet putInMap(String path, Serializable key, Serializable value) {
        return this.add(new PutInMapSpaceEntryMutator(path, key, value));
    }

    public ChangeSet removeFromMap(String path, Serializable key) {
        return this.add(new RemoveFromMapSpaceEntryMutator(path, key));
    }

    public ChangeSet lease(long lease) {
        this._lease = lease;
        return this;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this._mutators.size());
        for (SpaceEntryMutator mutator : this._mutators) {
            IOUtils.writeObject(out, mutator);
        }
        out.writeLong(this._lease);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        for (int i = 0; i < size; ++i) {
            SpaceEntryMutator mutator = (SpaceEntryMutator)IOUtils.readObject(in);
            this._mutators.add(mutator);
        }
        this._lease = in.readLong();
    }

    public String toString() {
        return Textualizer.toString(this);
    }

    final Collection<SpaceEntryMutator> getMutators() {
        return this._mutators;
    }

    final long getLease() {
        return this._lease;
    }

    @Override
    public void toText(Textualizer textualizer) {
        textualizer.appendIterable("mutators", this._mutators);
    }

    public ChangeSet disablePathCaching(String ... nonCachedPaths) {
        this._nonCachedPaths = nonCachedPaths == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(nonCachedPaths));
        return this;
    }

    Set<String> getNonCachedPaths() {
        return this._nonCachedPaths;
    }
}

