/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.SpaceProxyOperationModifiers;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateOnceMap;
import java.util.Map;

public class CountModifiers
extends IsolationLevelModifiers {
    private static final long serialVersionUID = -6407978572185535198L;
    public static final CountModifiers NONE = new CountModifiers(0);
    public static final CountModifiers REPEATABLE_READ = new CountModifiers(0);
    public static final CountModifiers READ_COMMITTED = new CountModifiers(8192);
    public static final CountModifiers DIRTY_READ = new CountModifiers(32);
    public static final CountModifiers EXCLUSIVE_READ_LOCK = new CountModifiers(512);
    public static final CountModifiers MEMORY_ONLY_SEARCH = new CountModifiers(0x1000000);
    private static final Map<Integer, SpaceProxyOperationModifiers> cache = CountModifiers.initCache();

    private static Map<Integer, SpaceProxyOperationModifiers> initCache() {
        CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers> initialValues = new CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers>();
        initialValues.put(NONE.getCode(), NONE);
        initialValues.put(REPEATABLE_READ.getCode(), REPEATABLE_READ);
        initialValues.put(READ_COMMITTED.getCode(), READ_COMMITTED);
        initialValues.put(DIRTY_READ.getCode(), DIRTY_READ);
        initialValues.put(EXCLUSIVE_READ_LOCK.getCode(), EXCLUSIVE_READ_LOCK);
        initialValues.put(MEMORY_ONLY_SEARCH.getCode(), MEMORY_ONLY_SEARCH);
        return initialValues;
    }

    public CountModifiers() {
    }

    private CountModifiers(int code) {
        super(code);
    }

    public CountModifiers(CountModifiers modifiers1, CountModifiers modifiers2) {
        super((IsolationLevelModifiers)modifiers1, (IsolationLevelModifiers)modifiers2);
    }

    public CountModifiers(CountModifiers modifiers1, CountModifiers modifiers2, CountModifiers modifiers3) {
        super((IsolationLevelModifiers)modifiers1, (IsolationLevelModifiers)modifiers2, (IsolationLevelModifiers)modifiers3);
    }

    public CountModifiers(CountModifiers ... modifiers) {
        super(modifiers);
    }

    public boolean contains(CountModifiers modifiers) {
        return super.contains(modifiers);
    }

    public CountModifiers add(CountModifiers modifiers) {
        return (CountModifiers)this.createIfNeeded(super.add(modifiers));
    }

    public CountModifiers remove(CountModifiers modifiers) {
        return (CountModifiers)this.createIfNeeded(super.remove(modifiers));
    }

    public CountModifiers setIsolationLevel(CountModifiers isolationLevel) {
        return (CountModifiers)super.setIsolationLevel(isolationLevel);
    }

    public boolean isExclusiveReadLock() {
        return this.contains(EXCLUSIVE_READ_LOCK);
    }

    public boolean isMemoryOnlySearch() {
        return this.contains(MEMORY_ONLY_SEARCH);
    }

    @Override
    protected CountModifiers create(int modifiers) {
        return new CountModifiers(modifiers);
    }

    @Override
    protected Map<Integer, SpaceProxyOperationModifiers> getCache() {
        return cache;
    }
}

