/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.SpaceProxyOperationModifiers;
import com.j_spaces.core.client.Modifiers;

public abstract class IsolationLevelModifiers
extends SpaceProxyOperationModifiers {
    private static final long serialVersionUID = 1L;
    private static final int REPEATABLE_READ = 0;
    private static final int ALL_ISOLATION_LEVELS = 8224;

    public IsolationLevelModifiers() {
    }

    protected IsolationLevelModifiers(int code) {
        super(code);
    }

    protected IsolationLevelModifiers(IsolationLevelModifiers m1, IsolationLevelModifiers m2) {
        super((SpaceProxyOperationModifiers)m1, (SpaceProxyOperationModifiers)m2);
    }

    protected IsolationLevelModifiers(IsolationLevelModifiers m1, IsolationLevelModifiers m2, IsolationLevelModifiers m3) {
        super((SpaceProxyOperationModifiers)m1, (SpaceProxyOperationModifiers)m2, (SpaceProxyOperationModifiers)m3);
    }

    protected IsolationLevelModifiers(IsolationLevelModifiers ... modifiers) {
        super(modifiers);
    }

    public <T extends IsolationLevelModifiers> T setIsolationLevel(IsolationLevelModifiers isolationLevel) {
        if (isolationLevel == null) {
            return (T)this;
        }
        int isolationLevelCode = isolationLevel.getCode();
        if (isolationLevelCode != 32 && isolationLevelCode != 8192 && isolationLevelCode != 0) {
            throw new IllegalArgumentException("isolationLevel must be one of: REPEATABLE_READ, DIRTY_READ, READ_COMMITTED. Got [" + isolationLevelCode + " instead");
        }
        return (T)((IsolationLevelModifiers)this.createIfNeeded(Modifiers.remove(this.getCode(), 8224) | isolationLevelCode));
    }

    public boolean isRepeatableRead() {
        return !this.isReadCommitted() && !this.isDirtyRead();
    }

    public boolean isReadCommitted() {
        return Modifiers.contains(this.getCode(), 8192);
    }

    public boolean isDirtyRead() {
        return Modifiers.contains(this.getCode(), 32);
    }
}

