/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.SpaceProxyOperationModifiers;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateOnceMap;
import java.util.Map;

public class ReadModifiers
extends IsolationLevelModifiers {
    private static final long serialVersionUID = -5120634891611462402L;
    public static final ReadModifiers NONE = new ReadModifiers(0);
    public static final ReadModifiers REPEATABLE_READ = new ReadModifiers(0);
    public static final ReadModifiers READ_COMMITTED = new ReadModifiers(8192);
    public static final ReadModifiers DIRTY_READ = new ReadModifiers(32);
    public static final ReadModifiers EXCLUSIVE_READ_LOCK = new ReadModifiers(512);
    public static final ReadModifiers IGNORE_PARTIAL_FAILURE = new ReadModifiers(65536);
    public static final ReadModifiers FIFO = new ReadModifiers(2048);
    public static final ReadModifiers FIFO_GROUPING_POLL = new ReadModifiers(0x100000);
    public static final ReadModifiers MEMORY_ONLY_SEARCH = new ReadModifiers(0x1000000);
    public static final ReadModifiers IF_EXISTS = new ReadModifiers(256);
    private static final Map<Integer, SpaceProxyOperationModifiers> cache = ReadModifiers.initCache();

    private static Map<Integer, SpaceProxyOperationModifiers> initCache() {
        CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers> initialValues = new CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers>();
        initialValues.put(NONE.getCode(), NONE);
        initialValues.put(REPEATABLE_READ.getCode(), REPEATABLE_READ);
        initialValues.put(READ_COMMITTED.getCode(), READ_COMMITTED);
        initialValues.put(DIRTY_READ.getCode(), DIRTY_READ);
        initialValues.put(EXCLUSIVE_READ_LOCK.getCode(), EXCLUSIVE_READ_LOCK);
        initialValues.put(IGNORE_PARTIAL_FAILURE.getCode(), IGNORE_PARTIAL_FAILURE);
        initialValues.put(FIFO.getCode(), FIFO);
        initialValues.put(FIFO_GROUPING_POLL.getCode(), FIFO_GROUPING_POLL);
        initialValues.put(MEMORY_ONLY_SEARCH.getCode(), MEMORY_ONLY_SEARCH);
        initialValues.put(IF_EXISTS.getCode(), IF_EXISTS);
        return initialValues;
    }

    public ReadModifiers() {
    }

    private ReadModifiers(int code) {
        super(code);
    }

    public ReadModifiers(ReadModifiers modifiers1, ReadModifiers modifiers2) {
        super((IsolationLevelModifiers)modifiers1, (IsolationLevelModifiers)modifiers2);
    }

    public ReadModifiers(ReadModifiers modifiers1, ReadModifiers modifiers2, ReadModifiers modifiers3) {
        super((IsolationLevelModifiers)modifiers1, (IsolationLevelModifiers)modifiers2, (IsolationLevelModifiers)modifiers3);
    }

    public ReadModifiers(ReadModifiers ... modifiers) {
        super(modifiers);
    }

    public boolean contains(ReadModifiers modifiers) {
        return super.contains(modifiers);
    }

    public ReadModifiers add(ReadModifiers modifiers) {
        return (ReadModifiers)this.createIfNeeded(super.add(modifiers));
    }

    public ReadModifiers remove(ReadModifiers modifiers) {
        return (ReadModifiers)this.createIfNeeded(super.remove(modifiers));
    }

    public ReadModifiers setIsolationLevel(ReadModifiers isolationLevel) {
        return (ReadModifiers)super.setIsolationLevel(isolationLevel);
    }

    public boolean isExclusiveReadLock() {
        return this.contains(EXCLUSIVE_READ_LOCK);
    }

    public boolean isIgnorePartialFailure() {
        return this.contains(IGNORE_PARTIAL_FAILURE);
    }

    public boolean isFifo() {
        return this.contains(FIFO);
    }

    public boolean isFifoGroupingPoll() {
        return this.contains(FIFO_GROUPING_POLL);
    }

    public boolean isMemoryOnlySearch() {
        return this.contains(MEMORY_ONLY_SEARCH);
    }

    public boolean isIfExists() {
        return this.contains(IF_EXISTS);
    }

    @Override
    protected ReadModifiers create(int modifiers) {
        return new ReadModifiers(modifiers);
    }

    @Override
    protected Map<Integer, SpaceProxyOperationModifiers> getCache() {
        return cache;
    }
}

