/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.ReadByIdsException;
import com.gigaspaces.client.ReadTakeByIdResult;
import com.gigaspaces.client.TakeByIdsException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public abstract class ReadTakeByIdsException
extends RuntimeException
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected ReadTakeByIdResult[] _results;

    public ReadTakeByIdResult[] getResults() {
        return this._results;
    }

    public ReadTakeByIdsException() {
    }

    public static ReadTakeByIdsException newException(ReadTakeByIdResult[] results, boolean takeOperation) {
        if (takeOperation) {
            return new TakeByIdsException(results);
        }
        return new ReadByIdsException(results);
    }

    public static ReadTakeByIdsException newException(Object[] ids, Object[] results, Throwable[] exceptions, boolean takeOperation) {
        ReadTakeByIdResult[] exceptionResults = new ReadTakeByIdResult[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            exceptionResults[i] = new ReadTakeByIdResult(ids[i], results[i], exceptions[i]);
        }
        if (takeOperation) {
            return new TakeByIdsException(exceptionResults);
        }
        return new ReadByIdsException(exceptionResults);
    }

    public static ReadTakeByIdsException newException(Object[] ids, Throwable t, boolean takeOperation) {
        ReadTakeByIdResult[] results = new ReadTakeByIdResult[ids.length];
        for (int i = 0; i < results.length; ++i) {
            results[i] = new ReadTakeByIdResult(ids[i], null, t);
        }
        return ReadTakeByIdsException.newException(results, takeOperation);
    }

    public ReadTakeByIdsException(ReadTakeByIdResult[] results) {
        this._results = results;
    }

    public ReadTakeByIdsException(Object[] ids, Object[] results, Throwable[] exceptions) {
        this.constructResultsArray(ids, results, exceptions);
    }

    protected void constructResultsArray(Object[] ids, Object[] results, Throwable[] exceptions) {
        this._results = new ReadTakeByIdResult[results.length];
        for (int i = 0; i < results.length; ++i) {
            this._results[i] = new ReadTakeByIdResult(ids[i], results[i], exceptions[i]);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._results);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._results = (ReadTakeByIdResult[])in.readObject();
    }

    @Override
    public String getMessage() {
        HashMap errorTypes = new HashMap();
        HashMap errors = new HashMap();
        int resultsCounter = 0;
        int errorsCounter = 0;
        for (ReadTakeByIdResult result : this._results) {
            if (result.isError()) {
                Class<?> key = result.getError().getClass();
                if (errorTypes.containsKey(key)) {
                    errorTypes.put(key, 1 + (Integer)errorTypes.get(key));
                } else {
                    errorTypes.put(result.getError().getClass(), 1);
                    errors.put(result.getError().getClass(), result.getError());
                }
                ++errorsCounter;
                continue;
            }
            ++resultsCounter;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Success:").append(resultsCounter);
        sb.append(", errors:").append(errorsCounter);
        sb.append(", [");
        for (Map.Entry entry : errorTypes.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append("\nStackTrace: ");
            Throwable t = (Throwable)errors.get(entry.getKey());
            t.printStackTrace(new PrintWriter(new StringBuilderWriter(sb)));
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder builder;

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.builder.append(cbuf, off, len);
        }
    }
}

