/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.client.ClusterConfig;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.server.space.SpaceInstanceConfig;
import com.gigaspaces.internal.sync.mirror.MirrorDistributedTxnConfig;
import com.gigaspaces.internal.utils.StringUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.server.SpaceCustomComponent;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.client.SpaceFinder;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.client.SpaceURLParser;
import com.j_spaces.core.cluster.ReplicationFilterProvider;
import com.j_spaces.core.filters.FilterProvider;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceProxyFactory {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.common.spaceurl");
    private Map<String, Object> parameters;
    private Properties properties;
    private Properties urlProperties;
    private Properties beanLevelProperties;
    private String schema;
    private String lookupGroups;
    private String lookupLocators;
    private Integer lookupTimeout;
    private Boolean fifo;
    private Boolean versioned;
    private Boolean mirror;
    private FilterProvider[] filterProviders;
    private Map<String, SqlFunction> userDefineSqlFunctions;
    private ReplicationFilterProvider replicationFilterProvider;
    private ManagedDataSource externalDataSource;
    private SpaceDataSource spaceDataSource;
    private SpaceSynchronizationEndpoint spaceSynchronizationEndpoint;
    private SpaceTypeDescriptor[] typeDescriptors;
    private QueryExtensionProvider[] queryExtensionProviders;
    private Properties cachePolicyProperties;
    private ClusterConfig clusterConfig;
    private String instanceId;
    private MirrorDistributedTxnConfig mirrorDistributedTxnConfig;
    private Boolean secured;
    private CredentialsProvider credentialsProvider;
    private AttributeStore attributeStore;
    private List<SpaceCustomComponent> customComponents = new ArrayList<SpaceCustomComponent>();

    public ISpaceProxy createSpaceProxy(String url) throws MalformedURLException, FinderException {
        String[] urls = StringUtils.tokenizeToStringArray(url, ";");
        SpaceURL[] spacesUrls = new SpaceURL[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            spacesUrls[i] = this.createSpaceURL(urls[i]);
        }
        return (ISpaceProxy)SpaceFinder.find(spacesUrls, this.credentialsProvider);
    }

    public ISpaceProxy createSpaceProxy(String name, boolean isRemote) throws MalformedURLException, FinderException {
        String url = (isRemote ? "jini://*/" + this.getContainerName(name) + "/" : "/./") + name;
        SpaceURL spaceURL = this.createSpaceURL(url);
        return (ISpaceProxy)SpaceFinder.find(spaceURL, this.credentialsProvider);
    }

    private String getContainerName(String spaceName) {
        if (!StringUtils.hasLength(this.instanceId) || this.instanceId.equals("*")) {
            return "*";
        }
        return spaceName + "_container" + this.instanceId;
    }

    private SpaceURL createSpaceURL(String url) throws MalformedURLException {
        return SpaceURLParser.parseURL(url, this.createProperties(SpaceUrlUtils.isRemoteProtocol(url)));
    }

    /*
     * WARNING - void declaration
     */
    private Properties createProperties(boolean isRemote) {
        CredentialsProvider credentialsProvider;
        Properties props = new Properties();
        if (this.parameters != null) {
            props.putAll(this.parameters);
        }
        if (this.properties != null) {
            props.putAll((Map<?, ?>)this.properties);
        }
        if (this.urlProperties != null) {
            for (Map.Entry<Object, Object> entry : this.urlProperties.entrySet()) {
                props.put(SpaceUrlUtils.toCustomUrlProperty((String)entry.getKey()), entry.getValue());
            }
        }
        if (this.lookupGroups != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("groups"), this.lookupGroups);
        }
        if (this.lookupLocators != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("locators"), this.lookupLocators);
        }
        if (this.lookupTimeout != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("timeout"), this.lookupTimeout.toString());
        }
        if (this.schema != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("schema"), this.schema);
        }
        if (this.fifo != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("fifo"), Boolean.toString(this.fifo));
        }
        if (this.versioned != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("versioned"), Boolean.toString(this.versioned));
        }
        if (this.mirror != null) {
            props.put(SpaceUrlUtils.toCustomUrlProperty("mirror"), Boolean.toString(this.mirror));
        }
        if (this.filterProviders != null && this.filterProviders.length > 0) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Filters");
            props.put("filter-providers", this.filterProviders);
        }
        if (this.userDefineSqlFunctions != null && this.userDefineSqlFunctions.size() > 0) {
            props.put("user-sql-function", this.userDefineSqlFunctions);
        }
        if (this.replicationFilterProvider != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Replication filter provider");
            props.put("replication-filter-provider", this.replicationFilterProvider);
        }
        if (this.externalDataSource != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "External data source");
            if (this.spaceDataSource != null || this.spaceSynchronizationEndpoint != null) {
                throw new IllegalArgumentException("Cannot set both externalDataSource and spaceDataSource/spaceSynchronizationEndpoint - it is recommended to use spaceDataSource/spaceSynchronizationEndpoint since externalDataSource is deprecated");
            }
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("externalDataSource is deprecated - instead use spaceDataSource and/or spaceSynchronizationEndpoint");
            }
            props.put("external-data-source.data-source", this.externalDataSource);
            props.put("space-config.persistent.enabled", "true");
        }
        if (this.spaceDataSource != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Space data source");
            props.put("external-data-source.space-data-source", this.spaceDataSource);
            props.put("space-config.persistent.enabled", "true");
        }
        if (this.spaceSynchronizationEndpoint != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Synchronization endpoint interceptor");
            props.put("external-data-source.space-sync-endpoint", this.spaceSynchronizationEndpoint);
            props.put("space-config.persistent.enabled", "true");
        }
        SpaceInstanceConfig spaceInstanceConfig = (SpaceInstanceConfig)props.get("space-config");
        if (isRemote) {
            if (spaceInstanceConfig != null) {
                throw new IllegalArgumentException("space-config can only be used with an embedded Space");
            }
        } else if (spaceInstanceConfig == null) {
            spaceInstanceConfig = new SpaceInstanceConfig();
            props.put("space-config", spaceInstanceConfig);
        }
        if (this.typeDescriptors != null && this.typeDescriptors.length > 0) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Space Types");
            spaceInstanceConfig.setTypeDescriptors(this.typeDescriptors);
        }
        if (this.queryExtensionProviders != null && this.queryExtensionProviders.length > 0) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Query Extension Providers");
            spaceInstanceConfig.setQueryExtensionProviders(this.queryExtensionProviders);
        }
        if (this.cachePolicyProperties != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Cache policy");
            props.putAll((Map<?, ?>)this.cachePolicyProperties);
        }
        if (!this.customComponents.isEmpty()) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Custom Components");
            for (SpaceCustomComponent component : this.customComponents) {
                spaceInstanceConfig.addCustomComponent(component);
            }
        }
        if (this.mirrorDistributedTxnConfig != null) {
            SpaceProxyFactory.assertEmbedded(isRemote, "Distributed transaction processing configuration");
            if (this.schema == null || !this.schema.equalsIgnoreCase("mirror")) {
                throw new IllegalStateException("Distributed transaction processing configuration can only be set for a Mirror component");
            }
            if (this.mirrorDistributedTxnConfig.getDistributedTransactionWaitTimeout() != null) {
                props.put("space-config.mirror-service.distributed-transaction-processing.wait-timeout", this.mirrorDistributedTxnConfig.getDistributedTransactionWaitTimeout().toString());
            }
            if (this.mirrorDistributedTxnConfig.getDistributedTransactionWaitForOperations() != null) {
                props.put("space-config.mirror-service.distributed-transaction-processing.wait-for-operations", this.mirrorDistributedTxnConfig.getDistributedTransactionWaitForOperations().toString());
            }
        }
        if (this.beanLevelProperties != null) {
            props.putAll((Map<?, ?>)this.beanLevelProperties);
        }
        props.setProperty("com.j_spaces.core.container.shutdown_hook", "false");
        if (this.clusterConfig != null && this.clusterConfig.getSchema() != null) {
            props.setProperty(SpaceUrlUtils.toCustomUrlProperty("cluster_schema"), this.clusterConfig.getSchema());
            if (this.clusterConfig.getInstanceId() != null) {
                props.setProperty(SpaceUrlUtils.toCustomUrlProperty("id"), this.clusterConfig.getInstanceId().toString());
            }
            if (this.clusterConfig.getBackupId() != null && this.clusterConfig.getBackupId() != 0) {
                props.setProperty(SpaceUrlUtils.toCustomUrlProperty("backup_id"), this.clusterConfig.getBackupId().toString());
            }
            if (this.clusterConfig.getNumberOfInstances() != null) {
                void var4_9;
                String string = this.clusterConfig.getNumberOfInstances().toString();
                if (this.clusterConfig.getNumberOfBackups() != null && this.clusterConfig.getNumberOfBackups() > -1) {
                    String string2 = string + "," + this.clusterConfig.getNumberOfBackups();
                }
                props.setProperty(SpaceUrlUtils.toCustomUrlProperty("total_members"), (String)var4_9);
            }
        }
        if (this.beanLevelProperties != null && (credentialsProvider = CredentialsProviderHelper.extractMarshalledCredentials(this.beanLevelProperties, false)) != null) {
            this.credentialsProvider = credentialsProvider;
        }
        if (this.credentialsProvider == null && props.contains("security.username")) {
            String string = (String)props.remove("security.username");
            String password = (String)props.remove("security.password");
            this.credentialsProvider = new DefaultCredentialsProvider(string, password);
        }
        if (this.credentialsProvider != null) {
            props.put("secured", "true");
            CredentialsProviderHelper.appendCredentials(props, this.credentialsProvider);
        } else if (this.secured != null && this.secured.booleanValue()) {
            props.put("secured", "true");
        }
        if (this.attributeStore != null) {
            props.put("directPersistency.attribute-store", this.attributeStore);
        }
        return props;
    }

    private static void assertEmbedded(boolean isRemote, String componentName) {
        if (isRemote) {
            throw new IllegalArgumentException(componentName + " can only be used with an embedded Space");
        }
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setUrlProperties(Properties urlProperties) {
        this.urlProperties = urlProperties;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public void setLookupGroups(String lookupGroups) {
        this.lookupGroups = lookupGroups;
    }

    public void setLookupLocators(String lookupLocators) {
        this.lookupLocators = lookupLocators;
    }

    public void setLookupTimeout(Integer lookupTimeout) {
        this.lookupTimeout = lookupTimeout;
    }

    public void setFifo(boolean fifo) {
        this.fifo = fifo;
    }

    public void setVersioned(Boolean versioned) {
        this.versioned = versioned;
    }

    public void setMirror(Boolean mirror) {
        this.mirror = mirror;
    }

    public void setExternalDataSource(ManagedDataSource externalDataSource) {
        this.externalDataSource = externalDataSource;
    }

    public void setSpaceDataSource(SpaceDataSource spaceDataSource) {
        this.spaceDataSource = spaceDataSource;
    }

    public void setSpaceSynchronizationEndpoint(SpaceSynchronizationEndpoint spaceSynchronizationEndpoint) {
        this.spaceSynchronizationEndpoint = spaceSynchronizationEndpoint;
    }

    public void setTypeDescriptors(SpaceTypeDescriptor[] typeDescriptors) {
        this.typeDescriptors = typeDescriptors;
    }

    public void setQueryExtensionProviders(QueryExtensionProvider[] queryExtensionProviders) {
        this.queryExtensionProviders = queryExtensionProviders;
    }

    public void setCachePolicyProperties(Properties cachePolicyProperties) {
        this.cachePolicyProperties = cachePolicyProperties;
    }

    public void setBeanLevelProperties(Properties beanLevelProperties) {
        this.beanLevelProperties = beanLevelProperties;
    }

    public void setReplicationFilterProvider(ReplicationFilterProvider replicationFilterProvider) {
        this.replicationFilterProvider = replicationFilterProvider;
    }

    public void setFilterProviders(FilterProvider[] filterProviders) {
        this.filterProviders = filterProviders;
    }

    public void setUserDefineSqlFunctions(Map<String, SqlFunction> userDefineSqlFunctions) {
        this.userDefineSqlFunctions = userDefineSqlFunctions;
    }

    public void addFilterProvider(FilterProvider newFilterProvider) {
        if (this.filterProviders == null || this.filterProviders.length == 0) {
            this.filterProviders = new FilterProvider[]{newFilterProvider};
        } else {
            this.filterProviders = Arrays.copyOf(this.filterProviders, this.filterProviders.length + 1);
            this.filterProviders[this.filterProviders.length - 1] = newFilterProvider;
        }
    }

    public void addCustomComponent(SpaceCustomComponent component) {
        if (component != null) {
            this.customComponents.add(component);
        }
    }

    public void setClusterConfig(ClusterConfig clusterConfig) {
        this.clusterConfig = clusterConfig;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void setMirrorDistributedTxnConfig(MirrorDistributedTxnConfig mirrorDistributedTxnConfig) {
        this.mirrorDistributedTxnConfig = mirrorDistributedTxnConfig;
    }

    public void setSecured(Boolean secured) {
        this.secured = secured;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setAttributeStore(AttributeStore attributeStore) {
        this.attributeStore = attributeStore;
    }
}

