/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.SpaceProxyOperationModifiers;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateOnceMap;
import java.util.Map;

public class TakeModifiers
extends SpaceProxyOperationModifiers {
    private static final long serialVersionUID = 1L;
    public static final TakeModifiers NONE = new TakeModifiers(0);
    public static final TakeModifiers EVICT_ONLY = new TakeModifiers(131072);
    public static final TakeModifiers IGNORE_PARTIAL_FAILURE = new TakeModifiers(65536);
    public static final TakeModifiers FIFO = new TakeModifiers(2048);
    public static final TakeModifiers FIFO_GROUPING_POLL = new TakeModifiers(0x100000);
    public static final TakeModifiers MEMORY_ONLY_SEARCH = new TakeModifiers(0x1000000);
    public static final TakeModifiers IF_EXISTS = new TakeModifiers(256);
    private static final Map<Integer, SpaceProxyOperationModifiers> cache = TakeModifiers.initCache();

    private static Map<Integer, SpaceProxyOperationModifiers> initCache() {
        CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers> initialValues = new CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers>();
        initialValues.put(NONE.getCode(), NONE);
        initialValues.put(EVICT_ONLY.getCode(), EVICT_ONLY);
        initialValues.put(IGNORE_PARTIAL_FAILURE.getCode(), IGNORE_PARTIAL_FAILURE);
        initialValues.put(FIFO.getCode(), FIFO);
        initialValues.put(FIFO_GROUPING_POLL.getCode(), FIFO_GROUPING_POLL);
        initialValues.put(MEMORY_ONLY_SEARCH.getCode(), MEMORY_ONLY_SEARCH);
        initialValues.put(IF_EXISTS.getCode(), IF_EXISTS);
        return initialValues;
    }

    public TakeModifiers() {
    }

    private TakeModifiers(int code) {
        super(code);
    }

    public TakeModifiers(TakeModifiers modifiers1, TakeModifiers modifiers2) {
        super((SpaceProxyOperationModifiers)modifiers1, (SpaceProxyOperationModifiers)modifiers2);
    }

    public TakeModifiers(TakeModifiers modifiers1, TakeModifiers modifiers2, TakeModifiers modifiers3) {
        super((SpaceProxyOperationModifiers)modifiers1, (SpaceProxyOperationModifiers)modifiers2, (SpaceProxyOperationModifiers)modifiers3);
    }

    public TakeModifiers(TakeModifiers ... modifiers) {
        super(modifiers);
    }

    public boolean contains(TakeModifiers modifiers) {
        return super.contains(modifiers);
    }

    public TakeModifiers add(TakeModifiers modifiers) {
        return (TakeModifiers)this.createIfNeeded(super.add(modifiers));
    }

    public TakeModifiers remove(TakeModifiers modifiers) {
        return (TakeModifiers)this.createIfNeeded(super.remove(modifiers));
    }

    public boolean isEvictOnly() {
        return this.contains(EVICT_ONLY);
    }

    public boolean isIgnorePartialFailure() {
        return this.contains(IGNORE_PARTIAL_FAILURE);
    }

    public boolean isFifo() {
        return this.contains(FIFO);
    }

    public boolean isFifoGroupingPoll() {
        return this.contains(FIFO_GROUPING_POLL);
    }

    public boolean isMemoryOnlySearch() {
        return this.contains(MEMORY_ONLY_SEARCH);
    }

    public boolean isIfExists() {
        return this.contains(IF_EXISTS);
    }

    @Override
    protected TakeModifiers create(int modifiers) {
        return new TakeModifiers(modifiers);
    }

    @Override
    protected Map<Integer, SpaceProxyOperationModifiers> getCache() {
        return cache;
    }
}

