/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.client.SpaceProxyOperationModifiers;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateOnceMap;
import java.util.Map;

public class WriteModifiers
extends SpaceProxyOperationModifiers {
    private static final long serialVersionUID = 1L;
    public static final WriteModifiers NONE = new WriteModifiers(0);
    public static final WriteModifiers WRITE_ONLY = new WriteModifiers(4);
    public static final WriteModifiers UPDATE_ONLY = new WriteModifiers(8);
    public static final WriteModifiers UPDATE_OR_WRITE = new WriteModifiers(4096);
    public static final WriteModifiers PARTIAL_UPDATE = new WriteModifiers(16);
    public static final WriteModifiers RETURN_PREV_ON_UPDATE = new WriteModifiers(0x800000);
    public static final WriteModifiers ONE_WAY = new WriteModifiers(1);
    public static final WriteModifiers MEMORY_ONLY_SEARCH = new WriteModifiers(0x1000000);
    private static final Map<Integer, SpaceProxyOperationModifiers> cache = WriteModifiers.initCache();

    private static Map<Integer, SpaceProxyOperationModifiers> initCache() {
        CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers> initialValues = new CopyOnUpdateOnceMap<Integer, SpaceProxyOperationModifiers>();
        initialValues.put(NONE.getCode(), NONE);
        initialValues.put(WRITE_ONLY.getCode(), WRITE_ONLY);
        initialValues.put(UPDATE_ONLY.getCode(), UPDATE_ONLY);
        initialValues.put(UPDATE_OR_WRITE.getCode(), UPDATE_OR_WRITE);
        initialValues.put(PARTIAL_UPDATE.getCode(), PARTIAL_UPDATE);
        initialValues.put(RETURN_PREV_ON_UPDATE.getCode(), RETURN_PREV_ON_UPDATE);
        initialValues.put(ONE_WAY.getCode(), ONE_WAY);
        initialValues.put(MEMORY_ONLY_SEARCH.getCode(), MEMORY_ONLY_SEARCH);
        return initialValues;
    }

    public WriteModifiers() {
    }

    private WriteModifiers(int code) {
        super(code);
    }

    public WriteModifiers(WriteModifiers modifiers1, WriteModifiers modifiers2) {
        super((SpaceProxyOperationModifiers)modifiers1, (SpaceProxyOperationModifiers)modifiers2);
    }

    public WriteModifiers(WriteModifiers modifiers1, WriteModifiers modifiers2, WriteModifiers modifiers3) {
        super((SpaceProxyOperationModifiers)modifiers1, (SpaceProxyOperationModifiers)modifiers2, (SpaceProxyOperationModifiers)modifiers3);
    }

    public WriteModifiers(WriteModifiers ... modifiers) {
        super(modifiers);
    }

    public boolean contains(WriteModifiers modifiers) {
        return super.contains(modifiers);
    }

    public WriteModifiers add(WriteModifiers modifiers) {
        return (WriteModifiers)this.createIfNeeded(super.add(modifiers));
    }

    public WriteModifiers remove(WriteModifiers modifiers) {
        return (WriteModifiers)this.createIfNeeded(super.remove(modifiers));
    }

    public boolean isWriteOnly() {
        return this.contains(WRITE_ONLY);
    }

    public boolean isUpdateOnly() {
        return this.contains(UPDATE_ONLY);
    }

    public boolean isUpdateOrWrite() {
        return this.contains(UPDATE_OR_WRITE);
    }

    public boolean isPartialUpdate() {
        return this.contains(PARTIAL_UPDATE);
    }

    public boolean isReturnPrevOnUpdate() {
        return this.contains(RETURN_PREV_ON_UPDATE);
    }

    @Override
    protected WriteModifiers create(int modifiers) {
        return new WriteModifiers(modifiers);
    }

    @Override
    protected Map<Integer, SpaceProxyOperationModifiers> getCache() {
        return cache;
    }
}

