/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client;

import com.gigaspaces.internal.exceptions.WriteResultImpl;
import com.j_spaces.core.multiple.write.IWriteResult;
import com.j_spaces.core.multiple.write.WriteMultiplePartialFailureException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class WriteMultipleException
extends WriteMultiplePartialFailureException
implements Externalizable {
    private static final long serialVersionUID = 1L;

    public WriteMultipleException() {
    }

    public WriteMultipleException(IWriteResult[] results) {
        this._results = results;
    }

    @Override
    public IWriteResult[] getResults() {
        return this._results;
    }

    public WriteMultipleException(int length, Throwable e) {
        this._results = new IWriteResult[length];
        for (int i = 0; i < this._results.length; ++i) {
            this._results[i] = WriteResultImpl.createErrorResult(e);
        }
    }

    @Override
    public String getMessage() {
        HashMap errorTypes = new HashMap();
        HashMap errors = new HashMap();
        int resultsCounter = 0;
        int failures = 0;
        for (IWriteResult result : this._results) {
            if (result == null) {
                if (errorTypes.containsKey(Error.class)) {
                    errorTypes.put(Error.class, 1 + (Integer)errorTypes.get(Error.class));
                } else {
                    errorTypes.put(Error.class, 1);
                }
                ++failures;
                continue;
            }
            if (result.getResultType() == IWriteResult.ResultType.ERROR) {
                Class<?> key = result.getError().getClass();
                if (errorTypes.containsKey(key)) {
                    errorTypes.put(key, 1 + (Integer)errorTypes.get(key));
                } else {
                    errorTypes.put(result.getError().getClass(), 1);
                    errors.put(result.getError().getClass(), result.getError());
                }
                ++failures;
                continue;
            }
            ++resultsCounter;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Success:").append(resultsCounter);
        sb.append(", errors:").append(failures);
        sb.append(", [");
        for (Map.Entry entry : errorTypes.entrySet()) {
            sb.append(entry.getKey());
            sb.append(":");
            sb.append(entry.getValue());
            sb.append("\nStackTrace: ");
            Throwable t = (Throwable)errors.get(entry.getKey());
            t.printStackTrace(new PrintWriter(new StringBuilderWriter(sb)));
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._results = (IWriteResult[])in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._results);
    }

    private static class StringBuilderWriter
    extends Writer {
        private final StringBuilder builder;

        public StringBuilderWriter(StringBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
            this.builder.append(cbuf, off, len);
        }
    }

    public static interface IWriteResult
    extends com.j_spaces.core.multiple.write.IWriteResult {
    }
}

