/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.iterator;

import com.gigaspaces.SpaceRuntimeException;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.iterator.internal.SpaceIteratorAggregator;
import com.gigaspaces.client.iterator.internal.SpaceIteratorResult;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.client.spaceproxy.metadata.ObjectType;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.ITemplatePacket;
import com.gigaspaces.query.aggregators.AggregationSet;
import com.j_spaces.core.UidQueryPacket;
import com.j_spaces.jdbc.builder.SQLQueryTemplatePacket;
import java.io.Closeable;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;

@InternalApi
public class SpaceEntryPacketIterator
implements Iterator<IEntryPacket>,
Closeable {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.client.gsiterator");
    private final ISpaceProxy _spaceProxy;
    private final Transaction _txn;
    private final int _batchSize;
    private final int _readModifiers;
    private final ITemplatePacket _queryPacket;
    private final QueryResultTypeInternal _queryResultType;
    private final SpaceIteratorResult _iteratorResult;
    private final List<IEntryPacket> _buffer;
    private Iterator<IEntryPacket> _bufferIterator;
    private boolean _closed;

    public SpaceEntryPacketIterator(ISpaceProxy spaceProxy, Object query, Transaction txn, int batchSize, int modifiers) {
        if (spaceProxy == null) {
            throw new IllegalArgumentException("space argument must not be null.");
        }
        if (query == null) {
            throw new IllegalArgumentException("query argument must not be null.");
        }
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize argument must be greater than zero.");
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "SpaceIterator initialized with batchSize=" + batchSize);
        }
        this._spaceProxy = spaceProxy;
        this._txn = txn;
        this._batchSize = batchSize;
        this._readModifiers = modifiers;
        this._queryPacket = this.toTemplatePacket(query);
        this._queryResultType = this._queryPacket.getQueryResultType();
        this._iteratorResult = this.initialize();
        this._bufferIterator = this._iteratorResult.getEntries().iterator();
        this._buffer = new LinkedList<IEntryPacket>();
    }

    private ITemplatePacket toTemplatePacket(Object template) {
        ObjectType objectType = ObjectType.fromObject(template);
        ITemplatePacket templatePacket = this._spaceProxy.getDirectProxy().getTypeManager().getTemplatePacketFromObject(template, objectType);
        if (templatePacket instanceof SQLQueryTemplatePacket) {
            templatePacket = this._spaceProxy.getDirectProxy().getQueryManager().getSQLTemplate((SQLQueryTemplatePacket)templatePacket, null);
        }
        return templatePacket;
    }

    public ITemplatePacket getQueryPacket() {
        return this._queryPacket;
    }

    @Override
    public boolean hasNext() {
        boolean result;
        if (this._closed) {
            _logger.log(Level.FINER, "hasNext() returned false - iterator is closed");
            return false;
        }
        if (this._bufferIterator == null) {
            this._bufferIterator = this.getNextBatch();
        }
        if (this._bufferIterator == null) {
            result = false;
        } else if (this._bufferIterator.hasNext()) {
            result = true;
        } else {
            this._bufferIterator = null;
            result = this.hasNext();
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "hasNext() returned " + result);
        }
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public IEntryPacket next() {
        IEntryPacket entryPacket;
        IEntryPacket iEntryPacket = entryPacket = this.hasNext() ? this._bufferIterator.next() : null;
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "next() returned " + (entryPacket == null ? "null" : "object with uid=" + entryPacket.getUID()));
        }
        return entryPacket;
    }

    public Object nextEntry() {
        IEntryPacket entryPacket = this.next();
        return entryPacket != null ? this._spaceProxy.getDirectProxy().getTypeManager().convertQueryResult(entryPacket, this._queryPacket, false) : null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._closed = true;
            this._iteratorResult.close();
            if (this._bufferIterator != null) {
                while (this._bufferIterator.hasNext()) {
                    this._bufferIterator.next();
                }
            }
            this._buffer.clear();
        }
    }

    private SpaceIteratorResult initialize() {
        SpaceIteratorResult result;
        AggregationSet aggregationSet = new AggregationSet().add(new SpaceIteratorAggregator().setBatchSize(this._batchSize));
        try {
            result = (SpaceIteratorResult)this._spaceProxy.aggregate(this._queryPacket, aggregationSet, this._txn, this._readModifiers).get(0);
        }
        catch (RemoteException e) {
            throw new SpaceRuntimeException("Failed to initialize iterator", e);
        }
        catch (TransactionException e) {
            throw new SpaceRuntimeException("Failed to initialize iterator", e);
        }
        catch (InterruptedException e) {
            throw new SpaceRuntimeException("Failed to initialize iterator", e);
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "initialize found " + result.size() + " matching entries.");
        }
        return result;
    }

    private Iterator<IEntryPacket> getNextBatch() {
        this._buffer.clear();
        UidQueryPacket template = this._iteratorResult.buildQueryPacket(this._batchSize, this._queryResultType);
        if (template == null) {
            return null;
        }
        template.setProjectionTemplate(this._queryPacket.getProjectionTemplate());
        Iterator<IEntryPacket> result = null;
        try {
            Object[] entries = this._spaceProxy.readMultiple(template, this._txn, template.getMultipleUIDs().length, this._readModifiers);
            this._buffer.clear();
            for (Object entry : entries) {
                this._buffer.add((IEntryPacket)entry);
            }
            result = this._buffer.iterator();
        }
        catch (RemoteException e) {
            this.processNextBatchFailure(e);
        }
        catch (UnusableEntryException e) {
            this.processNextBatchFailure((Exception)((Object)e));
        }
        catch (TransactionException e) {
            this.processNextBatchFailure((Exception)((Object)e));
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "getNextBatch returns with a buffer of " + this._buffer.size() + " entries.");
        }
        return result;
    }

    private void processNextBatchFailure(Exception e) {
        if (_logger.isLoggable(Level.SEVERE)) {
            _logger.log(Level.SEVERE, "Failed to build iterator data", e);
        }
    }
}

