/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.iterator;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ReadModifiers;
import com.gigaspaces.client.iterator.SpaceEntryPacketIterator;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.client.SQLQuery;
import java.io.Closeable;
import java.util.Iterator;
import net.jini.core.transaction.Transaction;

@InternalApi
public class SpaceIterator<T>
implements Iterator<T>,
Iterable<T>,
Closeable {
    private final SpaceEntryPacketIterator iterator;

    public static int getDefaultBatchSize() {
        return 100;
    }

    public SpaceIterator(ISpaceProxy spaceProxy, Object query, Transaction txn, int batchSize, ReadModifiers modifiers) {
        if (query instanceof SQLQuery && ((SQLQuery)query).getExplainPlan() != null) {
            throw new UnsupportedOperationException("Sql explain plan does not support space iterator");
        }
        this.iterator = new SpaceEntryPacketIterator(spaceProxy, query, txn, batchSize, modifiers.getCode());
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public T next() {
        return (T)this.iterator.nextEntry();
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }

    @Override
    public void close() {
        this.iterator.close();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

