/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.iterator.internal;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.query.IPartitionResultMetadata;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.j_spaces.core.UidQueryPacket;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

@InternalApi
public class MultipleUidsPerPartitionList {
    private int _numOfPartitions;
    private final Set<Object> _internalList = new LinkedHashSet<Object>();

    public int size() {
        return this._internalList.size() - this._numOfPartitions;
    }

    public void clear() {
        this._internalList.clear();
        this._numOfPartitions = 0;
    }

    public boolean addIfNew(String uid) {
        return this._internalList.add(uid);
    }

    public void remove(String uid) {
        this._internalList.remove(uid);
    }

    public void startPartition(IPartitionResultMetadata partition) {
        ++this._numOfPartitions;
        this._internalList.add(partition);
    }

    public UidQueryPacket buildQueryPacket(int bufferSize, QueryResultTypeInternal resultType) {
        if (this.size() == 0) {
            return null;
        }
        int minBufferSize = Math.min(bufferSize, this.size());
        String[] uids = new String[minBufferSize];
        int idx = 0;
        LinkedList<IPartitionResultMetadata> partitions = new LinkedList<IPartitionResultMetadata>();
        int lastPartitionCount = 0;
        Iterator<Object> itor = this._internalList.iterator();
        while (itor.hasNext() && idx < minBufferSize) {
            Object o = itor.next();
            if (o.getClass() == String.class) {
                itor.remove();
                uids[idx++] = (String)o;
                ++lastPartitionCount;
                continue;
            }
            if (lastPartitionCount == 0 && !partitions.isEmpty()) {
                partitions.removeLast();
            }
            partitions.add((IPartitionResultMetadata)o);
            lastPartitionCount = 0;
        }
        Integer routing = partitions != null && partitions.size() == 1 ? ((IPartitionResultMetadata)partitions.get(0)).getPartitionId() : null;
        UidQueryPacket queryPacket = (UidQueryPacket)TemplatePacketFactory.createUidsPacket(uids, resultType, false);
        queryPacket.setRouting(routing);
        return queryPacket;
    }
}

