/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.iterator.internal;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.iterator.internal.SpaceIteratorAggregatorPartitionResult;
import com.gigaspaces.client.iterator.internal.SpaceIteratorResult;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregator;
import com.gigaspaces.query.aggregators.SpaceEntriesAggregatorContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;

@InternalApi
public class SpaceIteratorAggregator
extends SpaceEntriesAggregator<SpaceIteratorAggregatorPartitionResult>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private int batchSize;
    private transient SpaceIteratorAggregatorPartitionResult result;
    private transient SpaceIteratorResult finalResult;

    public SpaceIteratorAggregator setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public String getDefaultAlias() {
        return null;
    }

    @Override
    public void aggregate(SpaceEntriesAggregatorContext context) {
        if (this.result == null) {
            this.result = new SpaceIteratorAggregatorPartitionResult(context.getPartitionId());
        }
        if (this.result.getEntries().size() < this.batchSize) {
            this.result.getEntries().add((IEntryPacket)context.getRawEntry());
        } else {
            if (this.result.getUids() == null) {
                this.result.setUids(new ArrayList<String>());
            }
            this.result.getUids().add(context.getEntryUid());
        }
    }

    @Override
    public SpaceIteratorAggregatorPartitionResult getIntermediateResult() {
        return this.result;
    }

    @Override
    public void aggregateIntermediateResult(SpaceIteratorAggregatorPartitionResult partitionResult) {
        if (this.finalResult == null) {
            this.finalResult = new SpaceIteratorResult();
        }
        this.finalResult.addPartition(partitionResult);
    }

    @Override
    public Object getFinalResult() {
        if (this.result != null) {
            this.aggregateIntermediateResult(this.result);
        }
        return this.finalResult != null ? this.finalResult : new SpaceIteratorResult();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.batchSize);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.batchSize = in.readInt();
    }
}

