/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.iterator.internal;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.iterator.internal.SpaceIteratorAggregatorPartitionResult;
import com.gigaspaces.internal.client.QueryResultTypeInternal;
import com.gigaspaces.internal.transport.IEntryPacket;
import com.gigaspaces.internal.transport.TemplatePacketFactory;
import com.gigaspaces.internal.utils.CollectionUtils;
import com.j_spaces.core.UidQueryPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@InternalApi
public class SpaceIteratorResult {
    private final List<IEntryPacket> entries = new ArrayList<IEntryPacket>();
    private final Map<Integer, LinkedList<String>> partitionedUids = new HashMap<Integer, LinkedList<String>>();

    public void addPartition(SpaceIteratorAggregatorPartitionResult partitionResult) {
        this.entries.addAll(partitionResult.getEntries());
        if (partitionResult.getUids() != null) {
            this.partitionedUids.put(partitionResult.getPartitionId(), new LinkedList<String>(partitionResult.getUids()));
        }
    }

    public List<IEntryPacket> getEntries() {
        return this.entries;
    }

    public void close() {
        this.entries.clear();
        this.partitionedUids.clear();
    }

    public UidQueryPacket buildQueryPacket(int batchSize, QueryResultTypeInternal resultType) {
        Integer partitionId = CollectionUtils.first(this.partitionedUids.keySet());
        if (partitionId == null) {
            return null;
        }
        LinkedList<String> uids = this.partitionedUids.get(partitionId);
        String[] batch = new String[Math.min(batchSize, uids.size())];
        Iterator iterator = uids.iterator();
        int index = 0;
        while (iterator.hasNext() && index < batch.length) {
            batch[index++] = (String)iterator.next();
            iterator.remove();
        }
        if (uids.isEmpty()) {
            this.partitionedUids.remove(partitionId);
        }
        UidQueryPacket queryPacket = (UidQueryPacket)TemplatePacketFactory.createUidsPacket(batch, resultType, false);
        queryPacket.setRouting(partitionId);
        return queryPacket;
    }

    public int size() {
        int size = this.entries.size();
        for (LinkedList<String> uids : this.partitionedUids.values()) {
            size += uids.size();
        }
        return size;
    }
}

