/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.protective;

import java.util.HashSet;
import java.util.Set;

public class ProtectiveMode {
    public static final String PROTECTIVE_MODE = "com.gs.protectiveMode";
    public static final String WRONG_ENTRY_ROUTING_USAGE = "com.gs.protectiveMode.wrongEntryRoutingUsage";
    public static final String AMBIGUOUS_QUERY_ROUTING_USAGE = "com.gs.protectiveMode.ambiguousQueryRoutingUsage";
    public static final String TYPE_WITHOUT_ID = "com.gs.protectiveMode.typeWithoutId";
    public static final String PRIMITIVE_WITHOUT_NULL_VALUE = "com.gs.protectiveMode.primitiveWithoutNullValue";
    public static final String QUERY_WITHOUT_INDEX = "com.gs.protectiveMode.queryWithoutIndex";
    private static final String TRUE = Boolean.TRUE.toString();
    private static final String FALSE = Boolean.FALSE.toString();
    private static final String PROTECT_WRONG_ROUTING_USAGE_DEFAULT = TRUE;
    private static final String PROTECT_AMBIGUOUS_QUERY_ROUTING_USAGE_DEFAULT = TRUE;
    private static final String TYPE_WITHOUT_ID_DEFAULT = TRUE;
    private static final String PRIMITIVE_WITHOUT_NULL_VALUE_DEFAULT = TRUE;
    private static final String QUERY_WITHOUT_INDEX_DEFAULT = FALSE;
    private static final boolean _enabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode", TRUE));
    private static final boolean _wrongRoutingUsageProtectionEnabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode.wrongEntryRoutingUsage", PROTECT_WRONG_ROUTING_USAGE_DEFAULT));
    private static final boolean _ambiguousQueryRoutingUsageProtectionEnabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode.ambiguousQueryRoutingUsage", PROTECT_AMBIGUOUS_QUERY_ROUTING_USAGE_DEFAULT));
    private static final boolean _typeWithoutIdProtectionEnabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode.typeWithoutId", TYPE_WITHOUT_ID_DEFAULT));
    private static final boolean _primitiveWithoutNullValueProtectionEnabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode.primitiveWithoutNullValue", PRIMITIVE_WITHOUT_NULL_VALUE_DEFAULT));
    private static final boolean _queryWithoutIndexProtectionEnabled = Boolean.parseBoolean(System.getProperty("com.gs.protectiveMode.queryWithoutIndex", QUERY_WITHOUT_INDEX_DEFAULT));
    private static final Set<String> _ignoreRoutingProtectiveModeTypeNames = new HashSet<String>();
    private static final Set<String> _ignoreWithoutIdProtectiveModeTypeNames = new HashSet<String>();

    public static boolean isEnabled() {
        return _enabled;
    }

    public static boolean isWrongRoutingUsageProtectionEnabled() {
        return ProtectiveMode.isEnabled() && _wrongRoutingUsageProtectionEnabled;
    }

    public static boolean shouldIgnoreWrongRoutingProtectiveMode(String typeName) {
        return _ignoreRoutingProtectiveModeTypeNames.contains(typeName);
    }

    public static boolean isAmbiguousQueryRoutingUsageProtectionEnabled() {
        return ProtectiveMode.isEnabled() && _ambiguousQueryRoutingUsageProtectionEnabled;
    }

    public static boolean isTypeWithoutIdProtectionEnabled() {
        return ProtectiveMode.isEnabled() && _typeWithoutIdProtectionEnabled;
    }

    public static boolean shouldIgnoreTypeWithoutIdProtectiveMode(String typeName) {
        return _ignoreWithoutIdProtectiveModeTypeNames.contains(typeName);
    }

    public static boolean isPrimitiveWithoutNullValueProtectionEnabled() {
        return ProtectiveMode.isEnabled() && _primitiveWithoutNullValueProtectionEnabled;
    }

    public static boolean isQueryWithoutIndexProtectionEnabled() {
        return ProtectiveMode.isEnabled() && _queryWithoutIndexProtectionEnabled;
    }

    static {
        _ignoreRoutingProtectiveModeTypeNames.add("org.openspaces.esb.mule.queue.OpenSpacesFifoQueueObject");
        _ignoreWithoutIdProtectiveModeTypeNames.add("org.openspaces.remoting.HashedEventDrivenSpaceRemotingEntry");
    }
}

