/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.transaction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.transaction.ITransactionManagerProvider;
import com.gigaspaces.client.transaction.MahaloFactory;
import com.sun.jini.admin.DestroyAdmin;
import com.sun.jini.mahalo.TxnManager;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class DistributedTransactionManagerProvider
implements ITransactionManagerProvider {
    private static TransactionManager _transactionManager;
    private static int _txnManagerReferencesCount;
    private static Object _lock;
    private boolean _destroyed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DistributedTransactionManagerProvider() throws TransactionException {
        Object object = _lock;
        synchronized (object) {
            if (_transactionManager == null) {
                try {
                    TxnManager impl = MahaloFactory.createMahalo();
                    _transactionManager = impl.getLocalProxy();
                    _txnManagerReferencesCount = 0;
                }
                catch (Exception e) {
                    throw new TransactionException(e.getMessage(), (Throwable)e);
                }
            }
            ++_txnManagerReferencesCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() throws RemoteException {
        Object object = _lock;
        synchronized (object) {
            if (this._destroyed) {
                return;
            }
            this._destroyed = true;
            if (--_txnManagerReferencesCount == 0) {
                Administrable admin = (Administrable)_transactionManager;
                if (admin == null) {
                    return;
                }
                _transactionManager = null;
                Object adminObject = admin.getAdmin();
                if (adminObject instanceof DestroyAdmin) {
                    ((DestroyAdmin)adminObject).destroy();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionManager getTransactionManager() {
        if (_transactionManager == null) {
            Object object = _lock;
            synchronized (object) {
                if (this._destroyed) {
                    throw new IllegalStateException("Transaction provider was already destroyed");
                }
            }
        }
        return _transactionManager;
    }

    protected void finalize() throws Throwable {
        try {
            this.destroy();
        }
        finally {
            super.finalize();
        }
    }

    static {
        _txnManagerReferencesCount = 0;
        _lock = new Object();
    }
}

