/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.transaction;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import java.lang.ref.WeakReference;
import java.util.Hashtable;
import net.jini.core.transaction.server.TransactionManager;

@InternalApi
public class TransactionManagersMap {
    private final Hashtable<ProxyComparator, WeakReference<TransactionManager>> _transactionManagersMap = new Hashtable();

    public TransactionManager get(IJSpace space) {
        WeakReference<TransactionManager> weakTxnManager = this._transactionManagersMap.get(new ProxyComparator(space));
        return weakTxnManager == null ? null : (TransactionManager)weakTxnManager.get();
    }

    public void put(IJSpace space, TransactionManager transactionManager) {
        this._transactionManagersMap.put(new ProxyComparator(space), new WeakReference<TransactionManager>(transactionManager));
    }

    public void remove(IJSpace space) {
        this._transactionManagersMap.remove(new ProxyComparator(space));
    }

    private static final class ProxyComparator {
        private final WeakReference<IJSpace> weakProxyReference;

        ProxyComparator(IJSpace proxy) {
            this.weakProxyReference = new WeakReference<IJSpace>(proxy);
        }

        private IJSpace getProxy() {
            return (IJSpace)this.weakProxyReference.get();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ProxyComparator)) {
                return false;
            }
            IJSpace objProxy = ((ProxyComparator)obj).getProxy();
            IJSpace thisProxy = this.getProxy();
            if (thisProxy == null || objProxy == null) {
                return false;
            }
            if (((ISpaceProxy)objProxy).isClustered()) {
                return thisProxy == objProxy;
            }
            return thisProxy.equals(objProxy);
        }

        public int hashCode() {
            IJSpace thisProxy = this.getProxy();
            if (thisProxy == null) {
                return -1;
            }
            return thisProxy.hashCode();
        }
    }
}

