/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.transaction.xa;

import com.gigaspaces.api.InternalApi;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.RemoteException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.core.transaction.server.TransactionParticipantDataImpl;

@InternalApi
public class GSServerTransaction
extends ServerTransaction {
    static final long serialVersionUID = 3346110305235074822L;
    private Object _id;

    public GSServerTransaction() {
    }

    public GSServerTransaction(TransactionManager tm, Object id, long lease) {
        super(tm, -1L, lease);
        this._id = id;
    }

    public static GSServerTransaction create(TransactionManager tm, Object id, long lease) throws RemoteException {
        GSServerTransaction txn = new GSServerTransaction(tm, id, lease);
        txn.initEmbedded();
        return txn;
    }

    public GSServerTransaction(TransactionManager tm, Object id) {
        super(tm, -1L);
        this._id = id;
    }

    public GSServerTransaction(TransactionManager tm, Object id, TransactionParticipantDataImpl metaData) {
        super(tm, -1L, metaData);
        this._id = id;
    }

    public int hashCode() {
        return this._id.hashCode() ^ this.mgr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof GSServerTransaction) {
            GSServerTransaction servertransaction = (GSServerTransaction)((Object)obj);
            return this._id.equals(servertransaction._id) && this.mgr.equals(servertransaction.mgr);
        }
        return false;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " [id=" + this._id + ", manager=" + this.mgr + "]";
    }

    public void commit() throws UnknownTransactionException, CannotCommitException, RemoteException {
        if (this.isXid()) {
            this.mgr.commit(this._id);
        } else {
            super.commit();
        }
    }

    public void commit(long l) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        if (this.isXid()) {
            this.mgr.commit(this._id, l);
        } else {
            super.commit(l);
        }
    }

    public void abort() throws UnknownTransactionException, CannotAbortException, RemoteException {
        if (this.isXid()) {
            this.mgr.abort(this._id);
        } else {
            super.abort();
        }
    }

    public void abort(long l) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException, RemoteException {
        if (this.isXid()) {
            this.mgr.abort(this._id, l);
        } else {
            super.abort(l);
        }
    }

    public void join(TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (this.isXid()) {
            if (crashCount == Long.MAX_VALUE) {
                this.mgr.join(this._id, part, crashCount, (ServerTransaction)this);
            } else {
                this.mgr.join(this._id, part, crashCount);
            }
        }
    }

    protected void join(TransactionParticipant part, long crashCount, int partitionId, String clusterName, Object proxy) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (crashCount != Long.MAX_VALUE) {
            throw new UnsupportedOperationException(" supported only for embedded join");
        }
        this.mgr.join(this._id, part, crashCount, (ServerTransaction)this, partitionId, clusterName, proxy);
    }

    public void join(TransactionParticipant part, long crashCount, int partitionId, String clusterName) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        if (crashCount == Long.MAX_VALUE) {
            throw new UnsupportedOperationException(" not supported for embedded join");
        }
        this.mgr.join(this._id, part, crashCount, partitionId, clusterName);
    }

    public int getState() throws UnknownTransactionException, RemoteException {
        if (this.isXid()) {
            return this.mgr.getState(this._id);
        }
        return super.getState();
    }

    public Object getId() {
        return this._id;
    }

    public boolean isXid() {
        return !(this._id instanceof Long);
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this._id);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this._id = in.readObject();
    }

    protected ServerTransaction createInstance() {
        return new GSServerTransaction();
    }

    public ServerTransaction createCopy() {
        GSServerTransaction copy = (GSServerTransaction)super.createCopy();
        copy._id = this._id;
        return copy;
    }
}

