/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.client.transaction.xa;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.UUID;
import javax.transaction.xa.Xid;

@InternalApi
public class GSXid
implements Xid,
Externalizable {
    static final long serialVersionUID = 836721541656259722L;
    private byte[] _branchQualifier;
    private int _formatId;
    private byte[] _globalTransactionId;
    private volatile transient int _hashCode = 0;
    private UUID _rmid;

    public GSXid() {
    }

    public GSXid(byte[] branchQualifier, int formatId, byte[] globalTransactionId) {
        this._branchQualifier = branchQualifier;
        this._formatId = formatId;
        this._globalTransactionId = globalTransactionId;
    }

    public GSXid(Xid xid) {
        this(xid.getBranchQualifier(), xid.getFormatId(), xid.getGlobalTransactionId());
    }

    public GSXid(Xid xid, UUID rmid) {
        this(xid);
        this._rmid = rmid;
        this.hashCode();
    }

    @Override
    public byte[] getBranchQualifier() {
        return this._branchQualifier;
    }

    @Override
    public int getFormatId() {
        return this._formatId;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this._globalTransactionId;
    }

    public boolean equals(Object obj) {
        boolean res = false;
        if (obj instanceof Xid) {
            Xid xid = (Xid)obj;
            boolean bl = res = Arrays.equals(xid.getBranchQualifier(), this._branchQualifier) && xid.getFormatId() == this._formatId && Arrays.equals(xid.getGlobalTransactionId(), this._globalTransactionId);
            if (res && obj instanceof GSXid) {
                GSXid other = (GSXid)obj;
                res = this._rmid != null ? other._rmid != null && this._rmid.equals(other._rmid) : other._rmid == null;
            }
        }
        return res;
    }

    public int hashCode() {
        if (this._hashCode != 0) {
            return this._hashCode;
        }
        for (int i = this._globalTransactionId.length - 1; i >= 0; --i) {
            this._hashCode += this._globalTransactionId[i] & 0xFF;
        }
        if (this._hashCode == 0) {
            this._hashCode = 1;
        }
        return this._hashCode;
    }

    @Override
    public void writeExternal(ObjectOutput objectoutput) throws IOException {
        objectoutput.writeInt(this._formatId);
        objectoutput.writeByte((byte)this._globalTransactionId.length);
        objectoutput.write(this._globalTransactionId);
        if (this._branchQualifier == null) {
            objectoutput.writeByte(-1);
        } else {
            objectoutput.writeByte((byte)this._branchQualifier.length);
            objectoutput.write(this._branchQualifier);
        }
        objectoutput.writeBoolean(this._rmid != null);
        if (this._rmid != null) {
            objectoutput.writeObject(this._rmid);
        }
    }

    @Override
    public void readExternal(ObjectInput objectinput) throws IOException, ClassNotFoundException {
        this._formatId = objectinput.readInt();
        byte bytecCount = objectinput.readByte();
        if (bytecCount < 0) {
            throw new IOException("Stream error.");
        }
        this._globalTransactionId = new byte[bytecCount];
        objectinput.readFully(this._globalTransactionId);
        bytecCount = objectinput.readByte();
        if (bytecCount < -1) {
            throw new IOException("Stream error.");
        }
        if (bytecCount > -1) {
            this._branchQualifier = new byte[bytecCount];
            objectinput.readFully(this._branchQualifier);
        }
        if (objectinput.readBoolean()) {
            this._rmid = (UUID)objectinput.readObject();
        }
        this.hashCode();
    }
}

