/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.impl.router.spacefinder.failuredetector.IFailureDetector;
import com.gigaspaces.internal.server.space.IRemoteSpace;
import com.j_spaces.core.cluster.startup.FaultDetectionListener;
import com.j_spaces.core.cluster.startup.GigaSpacesFaultDetectionHandler;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.lookup.ServiceID;

@InternalApi
public class ClusterFailureDetector
implements FaultDetectionListener,
IFailureDetector {
    private final Map<ServiceID, GigaSpacesFaultDetectionHandler> _failureDetectorsByID = new HashMap<ServiceID, GigaSpacesFaultDetectionHandler>();
    private final String[] _fdhConfig;
    public static final int DEFAULT_RETRY_COUNT = 3;
    public static final long DEFAULT_RETRY_TIMEOUT = 100L;
    public static final long DEFAULT_INVOCATION_DELAY = 1000L;

    public ClusterFailureDetector() {
        String className = GigaSpacesFaultDetectionHandler.class.getName();
        this._fdhConfig = new String[4];
        this._fdhConfig[0] = "-";
        this._fdhConfig[1] = className + ".retryCount=" + 3;
        this._fdhConfig[2] = className + ".invocationDelay=" + 1000L;
        this._fdhConfig[3] = className + ".retryTimeout=" + 100L;
    }

    public ClusterFailureDetector(String[] config) {
        this._fdhConfig = config;
    }

    @Override
    public void registerRemoteSpace(FaultDetectionListener listener, ServiceID serviceId, IRemoteSpace spaceProxy) throws Exception {
        this.register(listener, serviceId, spaceProxy);
    }

    public synchronized void register(FaultDetectionListener listener, ServiceID serviceId, Object service) throws Exception {
        GigaSpacesFaultDetectionHandler detector = this._failureDetectorsByID.get(serviceId);
        if (detector == null) {
            detector = new GigaSpacesFaultDetectionHandler();
            detector.setConfiguration(this._fdhConfig);
            this._failureDetectorsByID.put(serviceId, detector);
            detector.register(this);
        }
        detector.register(listener);
        try {
            detector.monitor(service, serviceId);
        }
        catch (Exception e) {
            this.serviceFailure(service, serviceId);
            throw e;
        }
    }

    @Override
    public synchronized void serviceFailure(Object service, Object serviceID) {
        GigaSpacesFaultDetectionHandler fHandler = this._failureDetectorsByID.get(serviceID);
        if (fHandler != null && fHandler.getSpaceProxy() == service) {
            this._failureDetectorsByID.remove(serviceID);
        }
    }

    public synchronized void terminate() {
        for (GigaSpacesFaultDetectionHandler detector : this._failureDetectorsByID.values()) {
            detector.terminate();
        }
        this._failureDetectorsByID.clear();
    }
}

