/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection;

import java.rmi.RemoteException;

public class InactiveSpaceException
extends RemoteException {
    private static final long serialVersionUID = 1L;
    private final String primarySpaceMemberName;
    private final String inActiveSpaceMemberName;

    public InactiveSpaceException(String inActiveSpaceMemberName, String primarySpaceMemberName) {
        this(inActiveSpaceMemberName, primarySpaceMemberName, "[" + inActiveSpaceMemberName + "] servers as backup-only space and can't accept any operation while primary [" + primarySpaceMemberName + "] space is alive.");
    }

    protected InactiveSpaceException(String inActiveSpaceMemberName, String primarySpaceMemberName, String msg) {
        super(msg);
        this.inActiveSpaceMemberName = inActiveSpaceMemberName;
        this.primarySpaceMemberName = primarySpaceMemberName;
    }

    public String getPrimarySpaceName() {
        return this.primarySpaceMemberName;
    }

    public String getInActiveSpaceName() {
        return this.inActiveSpaceMemberName;
    }
}

