/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection;

import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.LeaderSelector;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandlerConfig;
import com.gigaspaces.cluster.activeelection.PrimarySpaceModeListeners;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.lrmi.LRMIUtilities;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.core.exception.SpaceAlreadyStoppedException;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LeaderSelectorHandler
implements LeaderSelector {
    protected Logger _logger = null;
    protected String _spaceMember = null;
    protected SpaceImpl _space = null;
    protected PrimarySpaceModeListeners _primarySpaceModeListeners = null;
    private final ThreadLocal<ExecutorService> _dispatchRemoteEventExecutor = new ThreadLocal();
    protected volatile SpaceMode _spaceMode = SpaceMode.NONE;
    protected volatile Throwable _lastError;

    public void initialize(LeaderSelectorHandlerConfig config) throws Exception {
        this._logger = Logger.getLogger("com.gigaspaces.space.active-election." + config.getSpace().getNodeName());
        if (config.getSpace().getClusterPolicy().m_FailOverPolicy == null) {
            throw new IllegalArgumentException("Failed to initialize LeaderElectorHandler. FailoverPolicy is <null>");
        }
        this._space = config.getSpace();
        this._spaceMember = config.getSpace().getServiceName();
        this._primarySpaceModeListeners = config.getSpace().getPrimarySpaceModeListeners();
        ReplicationPolicy policy = config.getSpace().getClusterPolicy().getReplicationPolicy();
        if (policy != null) {
            policy.setPrimarySpaceSelector(this);
        }
    }

    @Override
    public boolean isPrimary() {
        return this._spaceMode == SpaceMode.PRIMARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void beforeSpaceModeChange(SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Invoking beforeSpaceModeChange event, new mode " + (Object)((Object)newMode));
        }
        LinkedList<ISpaceModeListener> remoteListeners = new LinkedList<ISpaceModeListener>();
        Iterator<ISpaceModeListener> iter = this._primarySpaceModeListeners.iterator();
        while (iter.hasNext()) {
            ISpaceModeListener listener = iter.next();
            try {
                SpaceInitializationIndicator.setInitializer();
                if (LRMIUtilities.isRemoteProxy(listener)) {
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.finest("located remote listener for beforeSpaceModeChange, adding to asynchronous dispatch queue [" + listener.toString() + "]");
                    }
                    remoteListeners.add(listener);
                    continue;
                }
                listener.beforeSpaceModeChange(newMode);
            }
            catch (DirectPersistencyRecoveryException dpe) {
                if (this._logger.isLoggable(Level.SEVERE)) {
                    this._logger.log(Level.SEVERE, dpe.getMessage());
                }
                throw dpe;
            }
            catch (Exception rex) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Failed to invoke method ISpaceModeListener.beforeSpaceModeChange(...) implemented by listener [" + listener + "]. Action Taken: Unregistered listener", rex);
                }
                this._primarySpaceModeListeners.removeListener(listener);
            }
            finally {
                SpaceInitializationIndicator.unsetInitializer();
            }
        }
        if (remoteListeners.size() > 0) {
            this.dispatchBeforeEventToRemoteListeners(remoteListeners, newMode);
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("completed invoking synchronous beforeSpaceModeChange event with mode " + (Object)((Object)newMode));
        }
    }

    protected synchronized void afterSpaceModeChange(SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Invoking afterSpaceModeChange event, new mode is " + (Object)((Object)newMode));
        }
        LinkedList<ISpaceModeListener> remoteListeners = new LinkedList<ISpaceModeListener>();
        Iterator<ISpaceModeListener> iter = this._primarySpaceModeListeners.iterator();
        while (iter.hasNext()) {
            ISpaceModeListener listener = iter.next();
            try {
                if (LRMIUtilities.isRemoteProxy(listener)) {
                    if (this._logger.isLoggable(Level.FINEST)) {
                        this._logger.finest("located remote listener for afterSpaceModeChange, adding to asynchronous dispatch queue [" + listener.toString() + "]");
                    }
                    remoteListeners.add(listener);
                    continue;
                }
                listener.afterSpaceModeChange(newMode);
            }
            catch (Exception rex) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Failed to invoke remote method ISpaceModeListener.afterSpaceModeChange(...) implemented by listener [" + listener + "]. Action Taken: Unregistered listener", rex);
                }
                this._primarySpaceModeListeners.removeListener(listener);
            }
        }
        if (remoteListeners.size() > 0) {
            this.dispatchAfterEventToRemoteListeners(remoteListeners, newMode);
        }
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("completed invoking synchronous afterSpaceModeChange event with mode " + (Object)((Object)newMode));
        }
    }

    protected void dispatchBeforeEventToRemoteListeners(Queue<ISpaceModeListener> remoteListeners, final SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("dispatching asynchronous beforeSpaceModeChange event, new mode is " + (Object)((Object)newMode) + ", pending listeners count is " + remoteListeners.size());
        }
        ExecutorService executor = Executors.newFixedThreadPool(1);
        this._dispatchRemoteEventExecutor.set(executor);
        while (!remoteListeners.isEmpty()) {
            final ISpaceModeListener remoteListener = remoteListeners.remove();
            final boolean isLast = remoteListeners.isEmpty();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        remoteListener.beforeSpaceModeChange(newMode);
                        if (isLast && LeaderSelectorHandler.this._logger.isLoggable(Level.FINEST)) {
                            LeaderSelectorHandler.this._logger.finest("completed invoking asynchronous beforeSpaceModeChange event with mode " + (Object)((Object)newMode));
                        }
                    }
                    catch (Exception e) {
                        if (LeaderSelectorHandler.this._logger.isLoggable(Level.FINE)) {
                            LeaderSelectorHandler.this._logger.log(Level.FINE, "Failed to invoke remote method ISpaceModeListener.beforeSpaceModeChange(...) implemented by listener [" + remoteListener + "]. Action Taken: Unregistered listener", e);
                        }
                        LeaderSelectorHandler.this._primarySpaceModeListeners.removeListener(remoteListener);
                    }
                }
            });
        }
    }

    private void dispatchAfterEventToRemoteListeners(Queue<ISpaceModeListener> remoteListeners, final SpaceMode newMode) {
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("dispatching asynchronous afterSpaceModeChange event, new mode is " + (Object)((Object)newMode) + ", pending listeners count is " + remoteListeners.size());
        }
        ExecutorService executor = this._dispatchRemoteEventExecutor.get();
        while (!remoteListeners.isEmpty()) {
            final ISpaceModeListener remoteListener = remoteListeners.remove();
            final boolean isLast = remoteListeners.isEmpty();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        remoteListener.afterSpaceModeChange(newMode);
                        if (isLast && LeaderSelectorHandler.this._logger.isLoggable(Level.FINEST)) {
                            LeaderSelectorHandler.this._logger.finest("completed invoking asynchronous afterSpaceModeChange event with mode " + (Object)((Object)newMode));
                        }
                    }
                    catch (Exception e) {
                        if (LeaderSelectorHandler.this._logger.isLoggable(Level.FINE)) {
                            LeaderSelectorHandler.this._logger.log(Level.FINE, "Failed to invoke remote method ISpaceModeListener.AfterSpaceModeChange(...) implemented by listener [" + remoteListener + "]. Action Taken: Unregistered listener", e);
                        }
                        LeaderSelectorHandler.this._primarySpaceModeListeners.removeListener(remoteListener);
                    }
                }
            });
        }
        executor.shutdown();
        this._dispatchRemoteEventExecutor.remove();
    }

    protected void moveToPrimary() {
        this.beforeSpaceModeChange(SpaceMode.PRIMARY);
        this.setSpaceMode(SpaceMode.PRIMARY);
        this.afterSpaceModeChange(SpaceMode.PRIMARY);
    }

    protected void moveToBackup() {
        this.beforeSpaceModeChange(SpaceMode.BACKUP);
        this.setSpaceMode(SpaceMode.BACKUP);
        this.afterSpaceModeChange(SpaceMode.BACKUP);
    }

    protected void moveToUnusable() {
        try {
            this._space.stopInternal();
        }
        catch (SpaceAlreadyStoppedException spaceAlreadyStoppedException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public synchronized void addListenerAndNotify(ISpaceModeListener listener) throws RemoteException {
        SpaceMode currentSpaceMode = this._spaceMode;
        listener.beforeSpaceModeChange(currentSpaceMode);
        listener.afterSpaceModeChange(currentSpaceMode);
        this._primarySpaceModeListeners.addListener(listener);
    }

    public synchronized void removeListener(ISpaceModeListener listener) {
        this._primarySpaceModeListeners.removeListener(listener);
    }

    public void setSpaceMode(SpaceMode spaceMode) {
        this._spaceMode = spaceMode;
    }

    public SpaceMode getSpaceMode() {
        return this._spaceMode;
    }

    public synchronized boolean compareAndRegister(SpaceMode spaceMode, ISpaceModeListener listener) {
        if (this._spaceMode != spaceMode) {
            return false;
        }
        this._primarySpaceModeListeners.addListener(listener);
        return true;
    }

    @Override
    public Throwable getLastError() {
        return this._lastError;
    }

    @Override
    public void setLastError(Throwable lastError) {
        this._lastError = lastError;
    }

    public void forceMoveToPrimary() throws RemoteException {
    }
}

