/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandler;
import com.gigaspaces.cluster.activeelection.LeaderSelectorHandlerConfig;
import com.gigaspaces.cluster.activeelection.PriorityElectionFilter;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionConfig;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionEvent;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionException;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionManager;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.cluster.activeelection.core.IActiveElectionListener;
import com.gigaspaces.cluster.activeelection.core.SplitBrainRecoveryHolder;
import com.gigaspaces.cluster.activeelection.core.SplitBrainRecoveryPolicy;
import com.gigaspaces.internal.client.spaceproxy.SpaceProxyImpl;
import com.gigaspaces.internal.naming.INamingService;
import com.gigaspaces.internal.naming.LookupNamingService;
import com.gigaspaces.internal.service.ServiceItemUtils;
import com.j_spaces.core.cluster.ClusterPolicy;
import com.j_spaces.core.service.Service;
import com.j_spaces.lookup.entry.ClusterGroup;
import com.j_spaces.lookup.entry.ClusterName;
import com.j_spaces.lookup.entry.HostName;
import com.j_spaces.lookup.entry.State;
import java.rmi.RemoteException;
import java.util.logging.Level;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.LookupDiscoveryManager;

@InternalApi
public class LusBasedSelectorHandler
extends LeaderSelectorHandler
implements IActiveElectionListener {
    private ActiveElectionManager _electManager;
    private INamingService _namingService;
    private volatile ServiceItem _primarySrvItem;
    private boolean _isTerminated = false;
    private SpaceProxyImpl _securedProxy;

    public LusBasedSelectorHandler(SpaceProxyImpl securedProxy) {
        this._securedProxy = securedProxy;
    }

    @Override
    public void initialize(LeaderSelectorHandlerConfig config) throws Exception {
        super.initialize(config);
        this._namingService = new LookupNamingService((LookupDiscoveryManager)config.getSpace().getJoinManager().getDiscoveryManager(), config.getSpace().getJoinManager().getLeaseRenewalManager());
        ServiceTemplate spaceTemplItem = this.buildServiceTemplate(config.getSpace().getClusterPolicy());
        PriorityElectionFilter electFilter = new PriorityElectionFilter(config.getSpace().getServiceName(), config.getSpace().getClusterPolicy().m_FailOverPolicy);
        ActiveElectionConfig _electConfig = config.getSpace().getClusterPolicy().m_FailOverPolicy.getActiveElectionConfig();
        SplitBrainRecoveryHolder splitBrainRecoveryHolder = new SplitBrainRecoveryHolder(SplitBrainRecoveryPolicy.getEnum(config.getSpace().getConfig().getProperty("space-config.split-brain.recovery-policy.after-detection", "discard-least-consistent")), config.getSpace().getQuiesceHandler());
        try {
            this._electManager = new ActiveElectionManager(config.getSpace().getNodeName(), this._securedProxy, spaceTemplItem, this._namingService, this, electFilter, _electConfig, config.getSpace().getClusterFailureDetector(), splitBrainRecoveryHolder, config.getSpace().getRecoveryIndicator());
        }
        catch (ActiveElectionException e) {
            throw new RemoteException(e.getMessage());
        }
    }

    private ServiceTemplate buildServiceTemplate(ClusterPolicy clusterPolicy) {
        ClusterName clusterName = new ClusterName(clusterPolicy.m_ClusterName);
        ClusterGroup clusterGroup = new ClusterGroup(clusterPolicy.m_FailOverPolicy.getElectionGroupName(), null, null);
        State state = new State();
        state.setElectable(Boolean.TRUE);
        Entry[] spaceTemplAttr = new Entry[]{clusterName, clusterGroup, state};
        Class[] serviceTypes = new Class[]{Service.class};
        return new ServiceTemplate(null, serviceTypes, spaceTemplAttr);
    }

    @Override
    public boolean isPrimary() {
        return this._spaceMode == SpaceMode.PRIMARY;
    }

    private void setPrimarySpaceItem(ServiceItem primarySrvItem) {
        this._primarySrvItem = primarySrvItem;
    }

    @Override
    public String getPrimaryMemberName() {
        return ServiceItemUtils.getSpaceMemberName(this._primarySrvItem);
    }

    @Override
    public void select() throws RemoteException {
        try {
            if (this._spaceMode == SpaceMode.NONE) {
                this._electManager.elect();
            } else {
                this._electManager.reelect();
            }
        }
        catch (ActiveElectionException e) {
            throw new RemoteException(this._spaceMember + " failed to elect Primary space", e);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void onActive(ActiveElectionEvent theEvent) {
        Object service;
        StringBuilder logBuf;
        ServiceItem primarySrvItem;
        ServiceItem activeServiceItem = theEvent.getActiveServiceItem();
        if (this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("PrimarySpaceSelector --> onActive: " + activeServiceItem);
        }
        if ((primarySrvItem = this._primarySrvItem) != null && !primarySrvItem.serviceID.equals((Object)activeServiceItem.serviceID)) {
            logBuf = new StringBuilder();
            String failurePrimaryHost = HostName.getHostNameFrom(primarySrvItem.attributeSets);
            service = primarySrvItem.getService();
            logBuf.append("Space instance identified primary [").append(service).append("] failure");
            if (failurePrimaryHost != null) {
                logBuf.append(" on [").append(failurePrimaryHost).append("] machine");
            }
            this._logger.info(logBuf.toString());
        }
        if (this._electManager.getState() == ActiveElectionState.State.ACTIVE) {
            this._logger.info("Space instance has been elected as Primary");
            this.moveToPrimary();
        } else {
            if (this._logger.isLoggable(Level.INFO)) {
                logBuf = new StringBuilder();
                String primaryHost = HostName.getHostNameFrom(activeServiceItem.attributeSets);
                service = activeServiceItem.getService();
                logBuf.append("Election resolved: Space instance [").append(service).append("]");
                if (primaryHost != null) {
                    logBuf.append(" on [").append(primaryHost).append("] machine");
                }
                logBuf.append(" has been elected to be Primary");
                this._logger.info(logBuf.toString());
                if (this.getSpaceMode() == SpaceMode.BACKUP) {
                    this._logger.info("Space instance remains Backup");
                } else {
                    this._logger.info("Space instance is Backup");
                }
            }
            this.setPrimarySpaceItem(activeServiceItem);
            this.moveToBackup();
        }
    }

    @Override
    public void onSplitBrain(ActiveElectionEvent theEvent) {
        if (this._electManager.getState() == ActiveElectionState.State.ACTIVE) {
            this.onSplitBrainActive(theEvent);
        } else {
            ServiceItem activeServiceItem = theEvent.getActiveServiceItem();
            if (this._primarySrvItem != null && !this._primarySrvItem.serviceID.equals((Object)activeServiceItem.serviceID)) {
                this.onSplitBrainBackup(theEvent);
            } else {
                StringBuilder logBuf = new StringBuilder();
                String primaryHost = HostName.getHostNameFrom(activeServiceItem.attributeSets);
                Object service = activeServiceItem.getService();
                logBuf.append("Split-Brain resolved: Space instance [").append(service).append("] ");
                if (primaryHost != null) {
                    logBuf.append("on [").append(primaryHost).append("] ");
                }
                logBuf.append("has been elected to be Primary");
                this._logger.info(logBuf.toString());
                this._logger.info("Space instance remains backup");
            }
        }
    }

    @Override
    public void onSplitBrainActive(ActiveElectionEvent theEvent) {
        this.setPrimarySpaceItem(null);
    }

    @Override
    public void onExtraBackup(ActiveElectionEvent theEvent) {
        ServiceItem activeServiceItem = theEvent.getActiveServiceItem();
        if (this.isPrimary() || activeServiceItem.serviceID.equals((Object)this._space.getUuid())) {
            this._logger.info("Election preceded extra-backup resolution - this Space instance: " + activeServiceItem.getService() + " remains a primary");
            return;
        }
        if (this._logger.isLoggable(Level.INFO)) {
            this._logger.info("Extra-backup resolved: primary Space instance [" + activeServiceItem + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "] is replicating to a different backup");
            this._logger.info("Space instance will discard of all data and become inaccessible");
        }
        this.setPrimarySpaceItem(null);
        this.setLastError(new ActiveElectionException("Space instance [" + this._spaceMember + "] is unusable after network reconnection. It will be redeployed if necessary by the Service Grid"));
        this.moveToUnusable();
    }

    @Override
    public void onSplitBrainBackup(ActiveElectionEvent theEvent) {
        ServiceItem activeServiceItem = theEvent.getActiveServiceItem();
        if (this._logger.isLoggable(Level.INFO)) {
            StringBuilder logBuf = new StringBuilder();
            String primaryHost = HostName.getHostNameFrom(activeServiceItem.attributeSets);
            Object service = activeServiceItem.getService();
            logBuf.append("Split-Brain resolved: Space instance [").append(service).append("] ");
            if (primaryHost != null) {
                logBuf.append("on [").append(primaryHost).append("] ");
            }
            logBuf.append("has been elected to be Primary");
            this._logger.info(logBuf.toString());
            this._logger.info("Space instance will discard of all data and recover from the primary [" + service + "]");
        }
        this.setPrimarySpaceItem(activeServiceItem);
        this.setLastError(new ActiveElectionException("Space [" + this._spaceMember + "] is unusable after split brain. It will be redeployed if necessary by the Service Grid"));
        this.moveToUnusable();
    }

    @Override
    public synchronized void terminate() {
        if (this._isTerminated) {
            return;
        }
        this._isTerminated = true;
        if (this._electManager != null) {
            this._electManager.terminate();
        }
        this._namingService.terminate();
        this._primarySpaceModeListeners.clear();
    }

    @Override
    public void forceMoveToPrimary() throws RemoteException {
        this._electManager.forceMoveToPrimary();
    }

    @Override
    public Throwable getLastError() {
        return this._lastError;
    }

    @Override
    public void setLastError(Throwable lastError) {
        this._lastError = lastError;
    }
}

