/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ICandidateEntry;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.cluster.activeelection.core.IActiveElectionDecisionFilter;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.cluster.FailOverPolicy;
import com.j_spaces.lookup.entry.ContainerName;
import com.j_spaces.lookup.entry.State;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.lookup.entry.Name;

@InternalApi
public class PriorityElectionFilter
implements IActiveElectionDecisionFilter {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.active-election");
    private final String _memberName;
    private final FailOverPolicy _failOverPolicy;

    public PriorityElectionFilter(String memberName, FailOverPolicy failOverPolicy) {
        this._memberName = memberName;
        this._failOverPolicy = failOverPolicy;
    }

    @Override
    public boolean isAcceptable(ActiveElectionState.State aquireState, List<ServiceItem> candidateSrv) {
        String STARTED_STATE = JSpaceState.convertToString(1);
        ArrayList<CandidateEntry> orderedMemberList = new ArrayList<CandidateEntry>();
        for (ServiceItem si : candidateSrv) {
            String memberName = this.getMemberName(si.attributeSets);
            String state = this.getMemberState(memberName, si.attributeSets);
            orderedMemberList.add(new CandidateEntry(memberName, STARTED_STATE.equals(state)));
        }
        Collections.sort(orderedMemberList);
        int orderId = orderedMemberList.indexOf(new CandidateEntry(this._memberName));
        if (orderId == -1 && _logger.isLoggable(Level.SEVERE)) {
            String msgEx = "Cluster may be in inconsistent state due to an illegal active election state: Space instance <" + this._memberName + "> is not registered as a candidate to become PRIMARY in LUS.\n Please restart the space cluster. ";
            _logger.severe(msgEx);
            return false;
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("PriorityElectionFilter - \n Member: [" + this._memberName + "] ask to acquire [" + (Object)((Object)aquireState) + "] state.\n OrderId: " + orderId + "\n Candidates: " + orderedMemberList + "\n Acquire accepted: " + (orderId == 0));
        }
        return orderId == 0;
    }

    private String getMemberState(String memberName, Entry[] spaceAttr) {
        for (Entry e1 : spaceAttr) {
            if (!(e1 instanceof State)) continue;
            return ((State)e1).state;
        }
        throw new IllegalArgumentException("Space: " + memberName + " registered on LookupService without " + State.class.getName() + " lookup attribute.");
    }

    private String getMemberName(Entry[] spaceAttr) {
        String spaceName = null;
        String containerName = null;
        for (Entry e1 : spaceAttr) {
            if (spaceName == null && e1 instanceof Name) {
                spaceName = ((Name)e1).name;
            }
            if (containerName != null || !(e1 instanceof ContainerName)) continue;
            containerName = ((ContainerName)e1).name;
        }
        if (spaceName == null || containerName == null) {
            throw new IllegalArgumentException("Space registered on LookupService with a wrong LookupAttributes: [Name=" + spaceName + ", ContainerName=" + containerName + "]");
        }
        return containerName + ":" + spaceName;
    }

    @Override
    public int compareTo(ServiceItem service1, ServiceItem service2) {
        ICandidateEntry entry1 = this.getCandidateEntry(service1);
        ICandidateEntry entry2 = this.getCandidateEntry(service2);
        return entry1.compareTo(entry2);
    }

    @Override
    public ICandidateEntry getCandidateEntry(ServiceItem service) {
        String STARTED_STATE = JSpaceState.convertToString(1);
        String memberName = this.getMemberName(service.attributeSets);
        String state = this.getMemberState(memberName, service.attributeSets);
        return new CandidateEntry(memberName, STARTED_STATE.equals(state));
    }

    public final class CandidateEntry
    implements ICandidateEntry {
        private final String memberName;
        private final boolean isStarted;

        @Override
        public String getMemberName() {
            return this.memberName;
        }

        @Override
        public boolean isStarted() {
            return this.isStarted;
        }

        private CandidateEntry(String memberName) {
            this(memberName, false);
        }

        private CandidateEntry(String memberName, boolean isStarted) {
            this.memberName = memberName;
            this.isStarted = isStarted;
        }

        @Override
        public int compareTo(ICandidateEntry currCandidate) {
            if (currCandidate.isStarted() && !this.isStarted) {
                return 1;
            }
            if (!currCandidate.isStarted() && this.isStarted) {
                return -1;
            }
            int memberOrderIndex = ((PriorityElectionFilter)PriorityElectionFilter.this)._failOverPolicy.failOverGroupMembersNames.indexOf(this.memberName);
            int candidateOrderIndex = ((PriorityElectionFilter)PriorityElectionFilter.this)._failOverPolicy.failOverGroupMembersNames.indexOf(currCandidate.getMemberName());
            return memberOrderIndex - candidateOrderIndex;
        }

        public boolean equals(Object obj) {
            return this.memberName.equals(((CandidateEntry)obj).memberName);
        }

        public String toString() {
            return "[ MemberName: " + this.memberName + ", Started: " + this.isStarted + " ]\n";
        }
    }
}

