/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceComponentsInitializeException;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.sun.jini.admin.DestroyAdmin;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class SpaceComponentManager
implements ISpaceModeListener {
    private SpaceImpl _space;
    private SpaceMode _spaceMode = SpaceMode.NONE;
    private LinkedList<ISpaceComponentsHandler> _componentsHandlers = new LinkedList();
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.active-election");

    public SpaceComponentManager(SpaceImpl space) throws SpaceComponentsInitializeException {
        this._space = space;
        this.init();
    }

    public void init() throws SpaceComponentsInitializeException {
        this._componentsHandlers = this._space.getSpaceComponentHandlers();
        try {
            SpaceInitializationIndicator.setInitializer();
            for (ISpaceComponentsHandler handler : this._componentsHandlers) {
                if (!handler.isRecoverySupported()) continue;
                handler.initComponents(false);
            }
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
        this._space.addInternalSpaceModeListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void beforeSpaceModeChange(SpaceMode newMode) {
        try {
            SpaceInitializationIndicator.setInitializer();
            switch (newMode) {
                case BACKUP: {
                    this.beforeMovingToBackup();
                    return;
                }
                case PRIMARY: {
                    this.beforeMovingToPrimary();
                    return;
                }
            }
            return;
        }
        catch (SpaceComponentsInitializeException e) {
            try {
                if (_logger.isLoggable(Level.SEVERE)) {
                    _logger.log(Level.SEVERE, "Failed to initialize space components, shutting down the space.", e);
                }
                ((DestroyAdmin)this._space.getAdmin()).destroy();
                return;
            }
            catch (RemoteException e1) {
                if (!_logger.isLoggable(Level.SEVERE)) return;
                _logger.log(Level.SEVERE, "Failed to shutdown space.", e1);
                return;
            }
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
    }

    private void closePrimaryOnlyComponents() {
        SpaceInitializationIndicator.setInitializer();
        for (ISpaceComponentsHandler handler : this._componentsHandlers) {
            handler.close(true);
        }
        SpaceInitializationIndicator.unsetInitializer();
    }

    @Override
    public void afterSpaceModeChange(SpaceMode newMode) {
        switch (newMode) {
            case BACKUP: {
                this.afterMovingToBackup();
                break;
            }
            case PRIMARY: {
                this.afterMovingToPrimary();
            }
        }
        this._spaceMode = newMode;
    }

    public void afterMovingToBackup() {
        switch (this._spaceMode) {
            case NONE: {
                this.startComponents(false);
                break;
            }
            case PRIMARY: {
                this.closePrimaryOnlyComponents();
            }
        }
    }

    private void afterMovingToPrimary() {
        switch (this._spaceMode) {
            case NONE: {
                this.startComponents(true);
                this.startComponents(false);
                break;
            }
            case BACKUP: {
                this.startComponents(true);
            }
        }
    }

    public void beforeMovingToBackup() throws SpaceComponentsInitializeException {
        switch (this._spaceMode) {
            case NONE: {
                this.initBackupComponents();
                break;
            }
        }
    }

    private void beforeMovingToPrimary() throws SpaceComponentsInitializeException {
        switch (this._spaceMode) {
            case NONE: {
                this.initPrimaryOnlyComponents();
                this.initBackupComponents();
                break;
            }
            case BACKUP: {
                this.initPrimaryOnlyComponents();
            }
        }
    }

    private void initPrimaryOnlyComponents() throws SpaceComponentsInitializeException {
        for (ISpaceComponentsHandler handler : this._componentsHandlers) {
            handler.initComponents(true);
        }
    }

    private void initBackupComponents() throws SpaceComponentsInitializeException {
        for (ISpaceComponentsHandler handler : this._componentsHandlers) {
            if (handler.isRecoverySupported()) continue;
            handler.initComponents(false);
        }
    }

    public void initComponents() throws SpaceComponentsInitializeException {
        try {
            SpaceInitializationIndicator.setInitializer();
            this.initPrimaryOnlyComponents();
            this.initBackupComponents();
        }
        finally {
            SpaceInitializationIndicator.unsetInitializer();
        }
    }

    private void startComponents(boolean spaceIsPrimary) {
        for (ISpaceComponentsHandler handler : this._componentsHandlers) {
            handler.startComponents(spaceIsPrimary);
        }
    }

    public void startComponents() {
        this.startComponents(true);
        this.startComponents(false);
        this._spaceMode = SpaceMode.PRIMARY;
    }

    public void restartSpaceComponents() throws SpaceComponentsInitializeException {
        this.init();
        SpaceMode newMode = this._spaceMode;
        this._spaceMode = SpaceMode.NONE;
        this.beforeSpaceModeChange(newMode);
        this.afterSpaceModeChange(newMode);
    }

    public LinkedList<ISpaceComponentsHandler> getComponentsHandlers() {
        return this._componentsHandlers;
    }

    public void setComponentsHandlers(LinkedList<ISpaceComponentsHandler> componentsHandlers) {
        this._componentsHandlers = componentsHandlers;
    }

    public SpaceImpl getSpace() {
        return this._space;
    }

    public void setSpace(SpaceImpl space) {
        this._space = space;
    }

    public SpaceMode getSpaceMode() {
        return this._spaceMode;
    }

    public void setSpaceMode(SpaceMode spaceMode) {
        this._spaceMode = spaceMode;
    }

    public void clear() {
        this._componentsHandlers.clear();
        this._space.removeInternalSpaceModeListener(this);
    }
}

