/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cluster.startup.GigaSpacesFaultDetectionHandler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ActiveElectionConfig
implements Externalizable {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_RETRY_COUNT = 60;
    public static final long DEFAULT_YIELD_TIME = 1000L;
    public static final long RESOLUTION_TIMEOUT_DEFAULT = 10000L;
    private int _retryConnection = 60;
    private long _yieldTime = 1000L;
    private long _resolutionTimeout = 10000L;
    public static final long DEFAULT_FAULTDETECTOR_INVOCATION_DELAY = 1000L;
    public static final int DEFAULT_FAULTDETECTOR_RETRY_COUNT = 3;
    public static final long DEFAULT_FAULTDETECTOR_RETRY_TIMEOUT = 100L;
    private long _faultDetectorInvocationDelay = 1000L;
    private int _faultDetectorRetryCount = 3;
    private long _faultDetectorRetryTimeout = 100L;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = 0;
        if (this._retryConnection != 60) {
            flags = (byte)(flags | 1);
        }
        if (this._yieldTime != 1000L) {
            flags = (byte)(flags | 2);
        }
        if (this._faultDetectorInvocationDelay != 1000L) {
            flags = (byte)(flags | 4);
        }
        if (this._faultDetectorRetryCount != 3) {
            flags = (byte)(flags | 8);
        }
        if (this._faultDetectorRetryTimeout != 100L) {
            flags = (byte)(flags | 0x10);
        }
        if (this._resolutionTimeout != 10000L) {
            flags = (byte)(flags | 0x20);
        }
        out.writeByte(flags);
        if (this._faultDetectorRetryCount != 3) {
            flags = (byte)(flags | 8);
        }
        if (this._retryConnection != 60) {
            out.writeInt(this._retryConnection);
        }
        if (this._yieldTime != 1000L) {
            out.writeLong(this._yieldTime);
        }
        if (this._faultDetectorInvocationDelay != 1000L) {
            out.writeLong(this._faultDetectorInvocationDelay);
        }
        if (this._faultDetectorRetryCount != 3) {
            out.writeInt(this._faultDetectorRetryCount);
        }
        if (this._faultDetectorRetryTimeout != 100L) {
            out.writeLong(this._faultDetectorRetryTimeout);
        }
        if (this._resolutionTimeout != 10000L) {
            out.writeLong(this._resolutionTimeout);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        this._retryConnection = (flags & 1) != 0 ? in.readInt() : 60;
        this._yieldTime = (flags & 2) != 0 ? in.readLong() : 1000L;
        this._faultDetectorInvocationDelay = (flags & 4) != 0 ? in.readLong() : 1000L;
        this._faultDetectorRetryCount = (flags & 8) != 0 ? in.readInt() : 3;
        this._faultDetectorRetryTimeout = (flags & 0x10) != 0 ? in.readLong() : 100L;
        this._resolutionTimeout = (flags & 0x20) != 0 ? in.readLong() : 10000L;
    }

    public int getRetryConnection() {
        return this._retryConnection;
    }

    public long getYieldTime() {
        return this._yieldTime;
    }

    public void setRetryConnection(int retryConnection) {
        this._retryConnection = retryConnection;
    }

    public void setYieldTime(long yieldTime) {
        this._yieldTime = yieldTime;
    }

    public long getFaultDetectorInvocationDelay() {
        return this._faultDetectorInvocationDelay;
    }

    public void setFaultDetectorInvocationDelay(long detectorInvocationDelay) {
        this._faultDetectorInvocationDelay = detectorInvocationDelay;
    }

    public int getFaultDetectorRetryCount() {
        return this._faultDetectorRetryCount;
    }

    public void setFaultDetectorRetryCount(int detectorRetryCount) {
        this._faultDetectorRetryCount = detectorRetryCount;
    }

    public long getFaultDetectorRetryTimeout() {
        return this._faultDetectorRetryTimeout;
    }

    public void setFaultDetectorRetryTimeout(long detectorRetryTimeout) {
        this._faultDetectorRetryTimeout = detectorRetryTimeout;
    }

    public long getResolutionTimeout() {
        return this._resolutionTimeout;
    }

    public void setResolutionTimeout(long resolutionTimeout) {
        this._resolutionTimeout = resolutionTimeout;
    }

    public String[] getFDHConfig() {
        String className = GigaSpacesFaultDetectionHandler.class.getName();
        String[] fdhConfig = new String[]{"-", className + ".retryCount=" + this.getFaultDetectorRetryCount(), className + ".invocationDelay=" + this.getFaultDetectorInvocationDelay(), className + ".retryTimeout=" + this.getFaultDetectorRetryTimeout()};
        return fdhConfig;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ActiveElectionConfig: ");
        sb.append("RetryConnection=" + this.getRetryConnection());
        sb.append(", YieldTime=" + this.getYieldTime());
        sb.append(", FaultDetectorInvocationDelay=" + this.getFaultDetectorInvocationDelay());
        sb.append(", FaultDetectorRetryCount=" + this.getFaultDetectorRetryCount());
        sb.append(", FaultDetectorRetryTimeout=" + this.getFaultDetectorRetryTimeout());
        sb.append(", ResolutionTimeout=" + this.getResolutionTimeout());
        return sb.toString();
    }

    private static interface BitMap {
        public static final byte RETRY_CONNECTION = 1;
        public static final byte YIELD_TIME = 2;
        public static final byte FAULT_DETECTOR_INV_DELAY = 4;
        public static final byte FAULT_DETECTOR_RETRY_COUNT = 8;
        public static final byte FAULT_DETECTOR_RETRY_TIMEOUT = 16;
        public static final byte RESOLUTION_TIMEOUT = 32;
    }
}

