/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.admin.quiesce.QuiesceState;
import com.gigaspaces.admin.quiesce.QuiesceStateChangedEvent;
import com.gigaspaces.admin.quiesce.QuiesceToken;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.ClusterFailureDetector;
import com.gigaspaces.cluster.activeelection.ICandidateEntry;
import com.gigaspaces.cluster.activeelection.LusBasedSelectorHandler;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionConfig;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionEvent;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionException;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.cluster.activeelection.core.ActiveFailureDetector;
import com.gigaspaces.cluster.activeelection.core.IActiveElectionDecisionFilter;
import com.gigaspaces.cluster.activeelection.core.IActiveElectionListener;
import com.gigaspaces.cluster.activeelection.core.ServiceReplicationStatus;
import com.gigaspaces.cluster.activeelection.core.SplitBrainController;
import com.gigaspaces.cluster.activeelection.core.SplitBrainRecoveryHolder;
import com.gigaspaces.cluster.activeelection.core.SplitBrainRecoveryPolicy;
import com.gigaspaces.cluster.activeelection.core.SplitBrainServiceEntry;
import com.gigaspaces.cluster.replication.IReplicationChannel;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.naming.INamingService;
import com.gigaspaces.internal.server.space.quiesce.QuiesceHandler;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyAttributeStoreException;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.StatisticsAdmin;
import com.j_spaces.core.filters.ReplicationStatistics;
import com.j_spaces.core.service.Service;
import com.j_spaces.lookup.entry.HostName;
import com.sun.jini.lookup.entry.LookupAttributes;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.id.ReferentUuid;

@InternalApi
public class ActiveElectionManager {
    private final Logger _logger;
    private final Logger _xbLogger;
    private final ActiveElectionConfig _config;
    private final IActiveElectionListener _listener;
    private final IActiveElectionDecisionFilter _decisionFilter;
    private final SplitBrainRecoveryHolder splitBrainRecoveryHolder;
    private ActiveFailureDetector _activeFailureDetector;
    private SplitBrainController _splitBrainController;
    private final INamingService _namingService;
    private final ElectionEntry _electTemplate;
    private final AtomicBoolean recoveryIndicator;
    private ActiveElectionState.State _currentState = ActiveElectionState.State.NONE;
    private boolean _isTerminated;
    private final ClusterFailureDetector _clusterFailureDetector;

    public ActiveElectionManager(String nodeName, Object service, ServiceTemplate participantSrvTemplate, INamingService namingSrv, IActiveElectionListener activeElectionListener, IActiveElectionDecisionFilter decisionFilter, ActiveElectionConfig config, ClusterFailureDetector clusterFailureDetector, SplitBrainRecoveryHolder splitBrainRecoveryHolder, AtomicBoolean recoveryIndicator) throws ActiveElectionException {
        this._logger = Logger.getLogger("com.gigaspaces.space.active-election." + nodeName);
        this._xbLogger = Logger.getLogger("com.gigaspaces.space.active-election.xbackup." + nodeName);
        if (service == null) {
            throw new NullPointerException("service can not be null.");
        }
        if (participantSrvTemplate.attributeSetTemplates == null && participantSrvTemplate.serviceTypes == null) {
            throw new IllegalArgumentException("ServiceTemplate can not be initialized with attributeSetTemplates=null and serviceTypes=null");
        }
        if (!(service instanceof ReferentUuid) && this._logger.isLoggable(Level.WARNING)) {
            this._logger.warning(service + " is not implements [" + ReferentUuid.class.getName() + "] interface. \t\t\t  In this case the service must provide the consistent equals() implementation.");
        }
        this._electTemplate = new ElectionEntry(service, participantSrvTemplate);
        this._namingService = namingSrv;
        this._listener = activeElectionListener;
        this._decisionFilter = decisionFilter;
        this._config = config;
        this._clusterFailureDetector = clusterFailureDetector;
        this.splitBrainRecoveryHolder = splitBrainRecoveryHolder;
        this.recoveryIndicator = recoveryIndicator;
        if (this._logger.isLoggable(Level.CONFIG)) {
            this._logger.config("Initialized with: \n\t\t ServiceTemplate: " + participantSrvTemplate + "\n\t\t NamingService: " + namingSrv.getName() + "\n\t\t ActiveElectionListener: " + activeElectionListener + "\n\t\t DecisionFilter: " + decisionFilter.getClass().getName() + "\n\t\t " + this._config);
        }
        this.initElectionState();
    }

    protected boolean isSpaceInRecovery() {
        return this.recoveryIndicator.get();
    }

    private void initElectionState() throws ActiveElectionException {
        try {
            int retryCount;
            int i = retryCount = this._config.getRetryConnection();
            while (i >= 0 && !this.isTerminate()) {
                this.registerPendingState();
                if (this.confirmPendingStateRegistration(retryCount)) break;
                if (retryCount == 0) {
                    throw new ActiveElectionException("Failed to initialize " + this.toString() + ". Check that [" + this._namingService.getName() + "] is available.");
                }
                --retryCount;
            }
            this.setCurrentState(ActiveElectionState.State.PENDING);
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Added initial [" + (Object)((Object)ActiveElectionState.State.PENDING) + "] state on [" + this._namingService.getName() + "]");
            }
        }
        catch (RemoteException ex) {
            String exMsg = "ActiveElectionManager failed to add [" + ActiveElectionState.class.getName() + "] attribute on [" + this._namingService.getName() + "] naming service.";
            if (this._logger.isLoggable(Level.SEVERE)) {
                this._logger.log(Level.SEVERE, exMsg, ex);
            }
            throw new ActiveElectionException(exMsg, ex);
        }
    }

    private void registerPendingState() throws RemoteException {
        Entry[] srvAttr = this._namingService.getLookupAttributes(this._electTemplate.getService());
        boolean isFound = false;
        for (Entry e : srvAttr) {
            if (!(e instanceof ActiveElectionState)) continue;
            isFound = true;
            break;
        }
        if (isFound) {
            this._logger.fine("register [PENDING] state as existing service attributes");
            this.changeState(null, ActiveElectionState.State.PENDING, true);
        } else {
            this._logger.fine("register [PENDING] state as new service attributes");
            this._namingService.addNamingAttributes(this._electTemplate.getService(), new Entry[]{new ActiveElectionState(ActiveElectionState.State.PENDING)});
        }
    }

    protected boolean confirmPendingStateRegistration(int retryCount) throws ActiveElectionException {
        ServiceTemplate srvTmpl = new ServiceTemplate(this._electTemplate._serviceID, new Class[]{Service.class}, new Entry[]{new ActiveElectionState(ActiveElectionState.State.PENDING)});
        ServiceItem[] srvMatch = this._namingService.lookup(srvTmpl, 1, null);
        if (srvMatch == null || srvMatch.length == 0) {
            if (this._logger.isLoggable(Level.INFO)) {
                this._logger.log(retryCount <= 10 ? Level.WARNING : Level.INFO, "Waiting [" + this._config.getYieldTime() + " ms] for [" + (Object)((Object)ActiveElectionState.State.PENDING) + "] state registration on " + this._namingService.getName() + " {remaining retries=" + retryCount + ", registrars=" + this._namingService.getNumberOfRegistrars() + "}");
            }
            try {
                Thread.sleep(this._config.getYieldTime());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new ActiveElectionException("ActiveElectionManager process was interrupted.");
            }
            return false;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("[" + (Object)((Object)ActiveElectionState.State.PENDING) + "] state registration successfully confirmed by " + this._namingService.getName());
        }
        return true;
    }

    protected List<ServiceItem> lookup(ActiveElectionState.State state, int maxMatches) throws InterruptedException {
        this.sleepYieldTime();
        this._electTemplate.setState(state);
        ServiceItem[] foundSrv = this._namingService.lookup(this._electTemplate, maxMatches, null);
        if (foundSrv == null) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("Lookup service not found while querying for state: " + (Object)((Object)this._electTemplate._actState.getState()));
            }
            return null;
        }
        List<ServiceItem> matchedSrv = ActiveElectionManager.trimServices(foundSrv);
        if (this._logger.isLoggable(Level.FINEST)) {
            int duplicates = foundSrv.length - matchedSrv.size();
            this._logger.finest("Found: [" + matchedSrv.size() + "] matches for  serviceTemplate: [" + this._electTemplate + "]; matched services: " + matchedSrv + (duplicates > 0 ? " duplicates: [" + duplicates + "]" : ""));
        }
        return matchedSrv;
    }

    protected boolean changeState(ActiveElectionState.State oldState, ActiveElectionState.State newState, boolean force) throws RemoteException {
        Object service = this._electTemplate.getService();
        ActiveElectionState oldJoinState = new ActiveElectionState(oldState);
        ActiveElectionState newJoinState = new ActiveElectionState(newState);
        while (!this.isTerminate()) {
            try {
                this._namingService.modifyNamingAttributes(service, new Entry[]{oldJoinState}, new Entry[]{newJoinState});
                this.setCurrentState(newState);
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Changed state from [" + (oldState == null ? "any" : oldState) + "] to [" + (Object)((Object)newState) + "]");
                }
                return true;
            }
            catch (RemoteException ex) {
                String msg = "ChangeState failed for service: " + service.getClass();
                if (force) {
                    msg = msg + ".ForceChange enabled - Retry again...";
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, msg, ex);
                }
                if (force) {
                    try {
                        Thread.sleep(this._config.getYieldTime());
                        continue;
                    }
                    catch (InterruptedException e) {
                        return false;
                    }
                }
                throw new RemoteException(msg, ex);
            }
        }
        return false;
    }

    static List<ServiceItem> trimServices(ServiceItem[] srvSet) {
        TreeSet<ServiceItem> treeSet = new TreeSet<ServiceItem>(new Comparator<ServiceItem>(){

            @Override
            public int compare(ServiceItem o1, ServiceItem o2) {
                ServiceID srvID_1 = o1.serviceID;
                ServiceID srvID_2 = o2.serviceID;
                return srvID_1.getMostSignificantBits() < srvID_2.getMostSignificantBits() ? -1 : (srvID_1.getMostSignificantBits() > srvID_2.getMostSignificantBits() ? 1 : (srvID_1.getLeastSignificantBits() < srvID_2.getLeastSignificantBits() ? -1 : (srvID_1.getLeastSignificantBits() > srvID_2.getLeastSignificantBits() ? 1 : 0)));
            }
        });
        if (srvSet != null) {
            Collections.addAll(treeSet, srvSet);
        }
        ArrayList<ServiceItem> trimSet = new ArrayList<ServiceItem>();
        trimSet.addAll(treeSet);
        return trimSet;
    }

    protected ServiceItem pollStateUntilAvailable(ActiveElectionState.State pollingState) throws InterruptedException {
        List<ServiceItem> matchedSrv;
        while (!this.isTerminate() && (matchedSrv = this.lookup(pollingState, 1)) != null && !matchedSrv.isEmpty()) {
            ServiceItem active;
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Found better election candidate - continue polling [" + (Object)((Object)pollingState) + "]...");
            }
            if ((active = this.findActive()) == null) continue;
            return active;
        }
        return null;
    }

    protected boolean isAdvanceToStateAllowed(ActiveElectionState.State currentState, ActiveElectionState.State acquireState) throws RemoteException, InterruptedException {
        List<ServiceItem> matchSrv;
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Request to advance from [" + (Object)((Object)currentState) + "] to [" + (Object)((Object)acquireState) + "]");
        }
        if ((matchSrv = this.lookup(currentState, Integer.MAX_VALUE)) == null) {
            throw new RemoteException(this._namingService.getName() + " is not available");
        }
        if (matchSrv.isEmpty()) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.warning("Cannot advance from [" + (Object)((Object)currentState) + "] to [" + (Object)((Object)acquireState) + "] - Current state is not available on " + this._namingService.getName() + "; force change state to [" + (Object)((Object)ActiveElectionState.State.PENDING) + "]");
            }
            this.changeState(null, ActiveElectionState.State.PENDING, true);
            this.sleepYieldTime();
            return false;
        }
        if (!this._decisionFilter.isAcceptable(acquireState, matchSrv)) {
            if (this._logger.isLoggable(Level.WARNING)) {
                this._logger.warning("Cannot advance from [" + (Object)((Object)currentState) + "] to [" + (Object)((Object)acquireState) + "] - found better candidate; force change state to [" + (Object)((Object)ActiveElectionState.State.PENDING) + "]");
            }
            this.changeState(null, ActiveElectionState.State.PENDING, true);
            this.sleepYieldTime();
            return false;
        }
        return true;
    }

    private boolean doChangeState(ActiveElectionState.State currentState, ActiveElectionState.State acquireState) throws RemoteException, InterruptedException {
        ServiceItem activeCandidate = this.findActive();
        if (activeCandidate != null) {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Advance from [" + (Object)((Object)currentState) + "] to [" + (Object)((Object)acquireState) + "] was rejected - found [" + activeCandidate.service + "] in [ACTIVE] state");
            }
            return false;
        }
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.fine("Advance from [" + (Object)((Object)currentState) + "] to [" + (Object)((Object)acquireState) + "] was accepted");
        }
        return this.changeState(currentState, acquireState, false);
    }

    private void sleepYieldTime() throws InterruptedException {
        long yieldTime = this._config.getYieldTime();
        Thread.sleep(yieldTime);
    }

    protected ServiceItem findActive() throws InterruptedException {
        while (!this.isTerminate()) {
            List<ServiceItem> matchedSrv = this.lookup(ActiveElectionState.State.ACTIVE, Integer.MAX_VALUE);
            if (matchedSrv == null || matchedSrv.isEmpty()) {
                return null;
            }
            if (matchedSrv.size() > 1) {
                if (!this._logger.isLoggable(Level.FINE)) continue;
                this._logger.fine("Identified network split-brain. Discovered [" + matchedSrv.size() + "] " + (Object)((Object)ActiveElectionState.State.ACTIVE) + " services. Waiting for split-brain resolution...");
                continue;
            }
            ServiceItem activeService = matchedSrv.get(0);
            try {
                ActiveFailureDetector detector;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Found [" + activeService.service + "] in ACTIVE state");
                }
                if ((detector = this._activeFailureDetector) == null || detector.isTerminate()) {
                    this._activeFailureDetector = new ActiveFailureDetector(this, activeService);
                }
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Registered active failure callback for [" + activeService.service + "]");
                }
            }
            catch (RemoteException e) {
                return null;
            }
            this.notifyListenerOnActive(activeService);
            return activeService;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void elect() throws InterruptedException, ActiveElectionException {
        boolean isException = false;
        if (this.getState() != ActiveElectionState.State.PENDING) {
            return;
        }
        try {
            block65: {
                while (!this.isTerminate()) {
                    try {
                        if (this.findActive() != null) {
                            return;
                        }
                    }
                    catch (DirectPersistencyRecoveryException ex) {
                        try {
                            if (this._logger.isLoggable(Level.WARNING)) {
                                if (ex instanceof DirectPersistencyAttributeStoreException) {
                                    this._logger.log(Level.WARNING, "Failed to set or get last primary state using AttributeStore, will try to reelect...", ex);
                                } else {
                                    this._logger.log(Level.WARNING, "Failed to elect as primary", ex);
                                }
                            }
                            isException = true;
                            this.changeState(this.getState(), ActiveElectionState.State.PENDING, true);
                            continue;
                        }
                        catch (RemoteException e) {
                            isException = true;
                            String exMsg = "Failed to communicate with [" + this._namingService.getName() + "] naming service while changing state from " + (Object)((Object)this.getState()) + " to PENDING. ";
                            throw new ActiveElectionException(exMsg, ex);
                        }
                    }
                    catch (RemoteException ex) {
                        isException = true;
                        String exMsg = "Failed to communicate with [" + this._namingService.getName() + "] naming service. ";
                        throw new ActiveElectionException(exMsg, ex);
                    }
                    if (this.pollStateUntilAvailable(ActiveElectionState.State.PREPARE) != null) {
                        return;
                    }
                    if (this.findActive() != null) {
                        return;
                    }
                    if (!this.isAdvanceToStateAllowed(ActiveElectionState.State.PENDING, ActiveElectionState.State.PREPARE)) continue;
                    if (!this.doChangeState(ActiveElectionState.State.PENDING, ActiveElectionState.State.PREPARE)) {
                        return;
                    }
                    if (this.findActive() != null) {
                        return;
                    }
                    if (!this.isAdvanceToStateAllowed(ActiveElectionState.State.PREPARE, ActiveElectionState.State.ACTIVE)) {
                        continue;
                    }
                    break block65;
                }
                return;
            }
            if (!this.doChangeState(ActiveElectionState.State.PREPARE, ActiveElectionState.State.ACTIVE)) {
                return;
            }
            this.notifyListenerOnActive(new ServiceItem(this._electTemplate.getServiceID(), this._electTemplate.getService(), null));
            return;
        }
        finally {
            if (!isException) {
                try {
                    if (this.getState() == ActiveElectionState.State.PREPARE) {
                        this.changeState(ActiveElectionState.State.PREPARE, ActiveElectionState.State.PENDING, true);
                    }
                }
                catch (RemoteException ex) {
                    throw new ActiveElectionException("Force change state failed.", ex);
                }
                try {
                    this.startSplitBrainController();
                }
                catch (Exception ex) {
                    throw new ActiveElectionException("Failed to start SplitBrainController.", ex);
                }
            }
        }
    }

    public void forceMoveToPrimary() throws RemoteException {
        if (this.getState() == ActiveElectionState.State.ACTIVE) {
            return;
        }
        this.changeState(ActiveElectionState.State.PENDING, ActiveElectionState.State.ACTIVE, true);
        this.notifyListenerOnActive(new ServiceItem(this._electTemplate.getServiceID(), this._electTemplate.getService(), null));
    }

    protected void notifyListenerOnActive(ServiceItem activeService) {
        if (SplitBrainController.isSplitBrainExecutor(Thread.currentThread())) {
            this._listener.onSplitBrain(new ActiveElectionEvent(activeService));
        } else {
            this._listener.onActive(new ActiveElectionEvent(activeService));
        }
    }

    protected void onSplitBrain(List<ServiceItem> splitActives) throws RemoteException, InterruptedException, ActiveElectionException {
        if (this._activeFailureDetector != null) {
            this._activeFailureDetector.terminate();
        }
        this.logSplitBrainDetection(splitActives);
        SplitBrainRecoveryPolicy splitBrainRecoveryPolicy = this.splitBrainRecoveryHolder.getSplitBrainRecoveryPolicy();
        this._logger.info("Split-brain recovery policy is: " + splitBrainRecoveryPolicy.toString());
        if (SplitBrainRecoveryPolicy.DISCARD_LEAST_CONSISTENT.equals((Object)splitBrainRecoveryPolicy)) {
            this.discardLeastConsistentOnSplitBrainDetection(splitActives);
        } else if (SplitBrainRecoveryPolicy.SUSPEND_PARTITION_PRIMARIES.equals((Object)splitBrainRecoveryPolicy)) {
            this.suspendPartitionPrimariesOnSplitBrainDetection();
        }
    }

    private void suspendPartitionPrimariesOnSplitBrainDetection() {
        QuiesceHandler quiesceHandler = this.splitBrainRecoveryHolder.getQuiesceHandler();
        if (!quiesceHandler.isOn()) {
            String description = "Space instance [" + this._electTemplate.service + "] is in Quiesce state until split-brain is resolved";
            QuiesceToken quiesceToken = quiesceHandler.createSpaceNameToken();
            quiesceHandler.setQuiesceMode(new QuiesceStateChangedEvent(QuiesceState.QUIESCED, quiesceToken, description));
            if (quiesceHandler.isOn()) {
                this._logger.info(description + " - Quiesce token [" + quiesceToken + "]");
            } else if (!quiesceHandler.isSupported()) {
                this._logger.warning("Split-brain will need to be resolved by terminating extra primary instances manually");
            }
        } else {
            this._logger.info("Space instance [" + this._electTemplate.service + "] is already in Quiesce state; awaiting resolution of split-brain");
        }
    }

    private void discardLeastConsistentOnSplitBrainDetection(List<ServiceItem> splitActives) throws InterruptedException, ActiveElectionException {
        this._logger.info("Space instance [" + this._electTemplate.service + "] is trying to resolve the split brain");
        if (this.getState() == ActiveElectionState.State.ACTIVE) {
            List<SplitBrainServiceEntry> splitBrainServiceEntries = this.getSplitBrainServices(splitActives);
            Collections.sort(splitBrainServiceEntries);
            SplitBrainServiceEntry electedPrimary = splitBrainServiceEntries.get(0);
            this.logSplitBrainResolution(splitBrainServiceEntries, electedPrimary);
            if (electedPrimary.getService().serviceID.equals((Object)this._electTemplate._serviceID)) {
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.fine("Split-brain resolved. Staying Primary");
                }
                this._listener.onSplitBrainActive(new ActiveElectionEvent(electedPrimary.getService()));
            } else {
                if (this._logger.isLoggable(Level.FINE)) {
                    Object service = electedPrimary.getService().getService();
                    this._logger.fine("Split-brain resolved. Space [" + service + "] remains Primary. ");
                }
                this._listener.onSplitBrainBackup(new ActiveElectionEvent(electedPrimary.getService()));
            }
        } else {
            this._logger.fine(" Split-brain -> looking for a new Primary.");
            this.elect();
        }
    }

    private void logSplitBrainResolution(List<SplitBrainServiceEntry> splitBrainServiceEntries, SplitBrainServiceEntry electedPrimary) {
        if (this._logger.isLoggable(Level.INFO)) {
            String resolutionReason = this.getResolutionReason(splitBrainServiceEntries);
            Object service = electedPrimary.getService().getService();
            StringBuilder sb = new StringBuilder();
            sb.append("Split brain was resolved - ").append(service).append(" was chosen because - ").append(resolutionReason).append(".\n");
            sb.append(" Split-brain resolution priority list [");
            sb.append(StringUtils.NEW_LINE);
            for (int i = 0; i < splitBrainServiceEntries.size(); ++i) {
                SplitBrainServiceEntry serviceEntry = splitBrainServiceEntries.get(i);
                sb.append(i + 1).append(". ");
                sb.append(serviceEntry.toString());
                sb.append(StringUtils.NEW_LINE);
            }
            sb.append("]");
            this._logger.info(sb.toString());
        }
    }

    private void logSplitBrainDetection(List<ServiceItem> splitActives) {
        if (this._logger.isLoggable(Level.WARNING)) {
            StringBuilder logBuf = new StringBuilder();
            logBuf.append("Split-Brain detected by space instance [" + this._electTemplate.service + "]. There is more than one primary space. Primary spaces are:\n");
            for (int i = 0; i < splitActives.size(); ++i) {
                ServiceItem activeServiceItem = splitActives.get(i);
                String activeHost = HostName.getHostNameFrom(activeServiceItem.attributeSets);
                Object service = activeServiceItem.getService();
                logBuf.append(" ").append(i + 1).append(". [").append(service).append("] space");
                if (activeHost != null) {
                    logBuf.append(" on [").append(activeHost).append("] machine.");
                }
                logBuf.append("\n");
            }
            this._logger.warning(logBuf.toString());
        }
    }

    public void onActiveDiscoveryCheckExtraBackup(ServiceItem activeServiceItem) {
        String targetMemberName = String.valueOf(this._electTemplate.service);
        ServiceID targetServiceID = this._electTemplate.getServiceID();
        if (!this.getSpaceMode().equals((Object)SpaceMode.BACKUP)) {
            if (this._xbLogger.isLoggable(Level.FINE)) {
                this._xbLogger.log(Level.FINE, "Space instance [" + this._electTemplate.service + "] current space mode [" + (Object)((Object)this.getSpaceMode()) + "] - validation requires [" + (Object)((Object)SpaceMode.BACKUP) + "]");
            }
            throw new CancellationException();
        }
        if (this.getState().equals((Object)ActiveElectionState.State.ACTIVE)) {
            if (this._xbLogger.isLoggable(Level.FINE)) {
                this._xbLogger.log(Level.FINE, "Space instance [" + this._electTemplate.service + "] current election state [" + (Object)((Object)this.getState()) + "] - validation requires [" + (Object)((Object)ActiveElectionState.State.ACTIVE) + "]");
            }
            throw new CancellationException();
        }
        if (targetMemberName.equals(String.valueOf(activeServiceItem.getService()))) {
            this._logger.warning("backup Space instance [" + this._electTemplate.service + "] will be removed since it has the same name identifier as the primary Space instance [" + activeServiceItem.service + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "]");
            this._listener.onExtraBackup(new ActiveElectionEvent(activeServiceItem));
            throw new CancellationException();
        }
        HashMap<String, ReplicationStatistics.OutgoingChannel> allOutgoingReplicationChannels = new HashMap<String, ReplicationStatistics.OutgoingChannel>();
        ServiceReplicationStatus serviceReplicationStatus = this.getServiceReplicationStatus(activeServiceItem, allOutgoingReplicationChannels);
        if (ServiceReplicationStatus.UNKNOWN.equals(serviceReplicationStatus) || ServiceReplicationStatus.UNREACHABLE_TARGET.equals(serviceReplicationStatus)) {
            if (this._xbLogger.isLoggable(Level.FINE)) {
                this._xbLogger.log(Level.FINE, "primary Space instance [" + activeServiceItem.service + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "] is unreachable");
            }
            throw new CancellationException();
        }
        if (!serviceReplicationStatus.containsReplicationTarget(targetMemberName)) {
            if (this._xbLogger.isLoggable(Level.FINEST)) {
                this._xbLogger.log(Level.FINEST, "backup Space instance [" + this._electTemplate.service + "] is not a replication target of primary Space instance [" + activeServiceItem.service + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "]");
            }
            return;
        }
        ReplicationStatistics.OutgoingChannel outgoingChannel = allOutgoingReplicationChannels.get(targetMemberName);
        if (!outgoingChannel.getReplicationMode().equals((Object)ReplicationStatistics.ReplicationMode.BACKUP_SPACE)) {
            if (this._xbLogger.isLoggable(Level.FINE)) {
                this._xbLogger.log(Level.FINE, "backup Space instance [" + this._electTemplate.service + "] current replication mode [" + (Object)((Object)outgoingChannel.getReplicationMode()) + "] - validation requires [ " + (Object)((Object)ReplicationStatistics.ReplicationMode.BACKUP_SPACE) + "]");
            }
            throw new CancellationException();
        }
        if (!outgoingChannel.getChannelState().equals((Object)ReplicationStatistics.ChannelState.ACTIVE)) {
            if (this._xbLogger.isLoggable(Level.FINEST)) {
                this._xbLogger.log(Level.FINEST, "backup Space instance [" + this._electTemplate.service + "] current replication channel state [" + (Object)((Object)outgoingChannel.getChannelState()) + "] - validation requires [" + (Object)((Object)ReplicationStatistics.ChannelState.ACTIVE) + "]");
            }
            return;
        }
        String targetServiceUuid = String.valueOf(targetServiceID);
        String outgoingChannelTargetUuid = String.valueOf(outgoingChannel.getTargetUuid());
        if (this._xbLogger.isLoggable(Level.FINER)) {
            this._xbLogger.log(Level.FINER, "backup Space instance [" + this._electTemplate.service + "] discovered a primary Space instance: [" + activeServiceItem.service + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "] with an outgoing replication channel - outgoingChannelTargetUuid=[" + outgoingChannelTargetUuid + "] compared to targetServiceUuid=[" + targetServiceUuid + (this._xbLogger.isLoggable(Level.FINEST) ? "] outgoingChannel=[" + outgoingChannel + "]" : "]"));
        }
        if (!String.valueOf(targetServiceID).equals(String.valueOf(outgoingChannel.getTargetUuid()))) {
            this._logger.warning("backup Space instance [" + this._electTemplate.service + "] has been detected as an extra backup Space and will be removed");
            this._listener.onExtraBackup(new ActiveElectionEvent(activeServiceItem));
        } else if (this._xbLogger.isLoggable(Level.FINE)) {
            this._xbLogger.log(Level.FINE, "backup Space instance [" + this._electTemplate.service + "] is a replication target of [" + activeServiceItem.service + "] on host [" + HostName.getHostNameFrom(activeServiceItem.attributeSets) + "]");
        }
        throw new CancellationException();
    }

    private String getResolutionReason(List<SplitBrainServiceEntry> splitBrainServiceEntries) {
        if (splitBrainServiceEntries.isEmpty()) {
            return "Unknown";
        }
        if (splitBrainServiceEntries.size() == 1) {
            return "Only one primary space detected";
        }
        SplitBrainServiceEntry chosenService = splitBrainServiceEntries.get(0);
        SplitBrainServiceEntry notChosenService = splitBrainServiceEntries.get(1);
        if (chosenService.getReplicationStatus().getPriority() < notChosenService.getReplicationStatus().getPriority()) {
            return "The space instance has the most consistent replication status";
        }
        return "All spaces matched the split brain resolution criteria. Chosen arbitrary";
    }

    private List<SplitBrainServiceEntry> getSplitBrainServices(List<ServiceItem> activeServices) {
        ServiceReplicationStatus replicationStatus;
        LinkedList<SplitBrainServiceEntry> entries = new LinkedList<SplitBrainServiceEntry>();
        HashMap<String, ReplicationStatistics.OutgoingChannel> allOutgoingReplicationChannels = new HashMap<String, ReplicationStatistics.OutgoingChannel>();
        for (ServiceItem activeService : activeServices) {
            replicationStatus = this.getServiceReplicationStatus(activeService, allOutgoingReplicationChannels);
            ICandidateEntry electionPriorityEntry = this.getElectionFilter().getCandidateEntry(activeService);
            SplitBrainServiceEntry entry = new SplitBrainServiceEntry(activeService, replicationStatus, electionPriorityEntry);
            entries.add(entry);
        }
        for (SplitBrainServiceEntry entry : entries) {
            replicationStatus = entry.getReplicationStatus();
            String serviceName = entry.getService().getService().toString();
            for (Map.Entry channelEntry : allOutgoingReplicationChannels.entrySet()) {
                if (serviceName.equals(channelEntry.getKey()) || replicationStatus.containsReplicationTarget((String)channelEntry.getKey())) continue;
                this.reduceReplicationStatusPriority(replicationStatus, (ReplicationStatistics.OutgoingChannel)channelEntry.getValue());
            }
        }
        return entries;
    }

    private ServiceReplicationStatus getServiceReplicationStatus(ServiceItem serviceItem, Map<String, ReplicationStatistics.OutgoingChannel> allOutgoingReplicationChannels) {
        Object service = serviceItem.getService();
        if (!(service instanceof ISpaceProxy)) {
            return ServiceReplicationStatus.UNKNOWN;
        }
        ServiceReplicationStatus serviceReplicationStatus = this.calculateServiceReplicationStatus((ISpaceProxy)service, serviceItem, allOutgoingReplicationChannels);
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("calculated replication status for " + serviceItem + " is " + serviceReplicationStatus);
        }
        return serviceReplicationStatus;
    }

    private ServiceReplicationStatus calculateServiceReplicationStatus(ISpaceProxy serviceProxy, ServiceItem serviceItem, Map<String, ReplicationStatistics.OutgoingChannel> allOutgoingReplicationChannels) {
        ServiceReplicationStatus serviceReplicationStatus;
        boolean hasDisconnected;
        int iteration = 0;
        long INCOMPLETE_ITERATION_SLEEP_TIME = 1000L;
        long MAX_TRIES = this._config.getResolutionTimeout() / INCOMPLETE_ITERATION_SLEEP_TIME + 1L;
        do {
            ++iteration;
            hasDisconnected = false;
            serviceReplicationStatus = new ServiceReplicationStatus();
            try {
                IInternalRemoteJSpaceAdmin admin = (IInternalRemoteJSpaceAdmin)serviceProxy.getAdmin();
                ReplicationStatistics replicationStatistics = ((StatisticsAdmin)((Object)admin)).getHolder().getReplicationStatistics();
                serviceReplicationStatus.setProcessId(admin.getJVMDetails().getPid());
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("calculating election priority for " + serviceItem + " try " + iteration + " out of " + MAX_TRIES);
                }
                if (replicationStatistics == null || replicationStatistics.getOutgoingReplication() == null || replicationStatistics.getOutgoingReplication().getChannels() == null) {
                    if (this._logger.isLoggable(Level.WARNING)) {
                        this._logger.warning("Failed to retrieve replicationStatistics for " + serviceItem);
                    }
                    return ServiceReplicationStatus.UNKNOWN;
                }
                for (ReplicationStatistics.OutgoingChannel outgoingChannel : replicationStatistics.getOutgoingReplication().getChannels()) {
                    allOutgoingReplicationChannels.put(outgoingChannel.getTargetMemberName(), outgoingChannel);
                    serviceReplicationStatus.addReplicationTargetName(outgoingChannel.getTargetMemberName());
                    if (outgoingChannel.isInconsistent()) {
                        this.reduceReplicationStatusPriority(serviceReplicationStatus, outgoingChannel);
                        continue;
                    }
                    if (outgoingChannel.getState() == IReplicationChannel.State.CONNECTED) continue;
                    String description = "Service replication with target [" + outgoingChannel.getTargetMemberName() + "] is inactive";
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.finer(description + ", reducing priority by " + 1000L);
                    }
                    serviceReplicationStatus.reducePriority(1000L, description);
                    hasDisconnected = true;
                }
                if (!hasDisconnected || (long)iteration >= MAX_TRIES) continue;
                try {
                    if (this._logger.isLoggable(Level.FINER)) {
                        this._logger.finer("there are disconnected replication targets, sleeping for " + INCOMPLETE_ITERATION_SLEEP_TIME + " and retrying");
                    }
                    Thread.sleep(INCOMPLETE_ITERATION_SLEEP_TIME);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return ServiceReplicationStatus.UNKNOWN;
                }
            }
            catch (RemoteException e) {
                if ((long)iteration < MAX_TRIES) {
                    try {
                        if (this._logger.isLoggable(Level.FINER)) {
                            this._logger.finer("target is unreachable, sleeping for " + INCOMPLETE_ITERATION_SLEEP_TIME + " and retrying");
                        }
                        Thread.sleep(INCOMPLETE_ITERATION_SLEEP_TIME);
                        continue;
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return ServiceReplicationStatus.UNKNOWN;
                    }
                }
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.log(Level.FINER, "Got exception while calculating replication priority", e);
                }
                return ServiceReplicationStatus.UNREACHABLE_TARGET;
            }
        } while (hasDisconnected && (long)iteration < MAX_TRIES);
        return serviceReplicationStatus;
    }

    private void reduceReplicationStatusPriority(ServiceReplicationStatus serviceReplicationStatus, ReplicationStatistics.OutgoingChannel outgoingChannel) {
        if (outgoingChannel.getReplicationMode() == ReplicationStatistics.ReplicationMode.MIRROR || outgoingChannel.getReplicationMode() == ReplicationStatistics.ReplicationMode.GATEWAY) {
            String targetType = outgoingChannel.getReplicationMode() == ReplicationStatistics.ReplicationMode.MIRROR ? "mirror" : "gateway";
            String description = "Service is inconsistent with a " + targetType + " target [" + outgoingChannel.getTargetMemberName() + "] (gives highest inconsistency state)";
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(description + ", reducing priority by " + 1000000000L);
            }
            serviceReplicationStatus.reducePriority(1000000000L, description);
        } else {
            String description = "Service is inconsistent with target [" + outgoingChannel.getTargetMemberName() + "]";
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer(description + ", reducing priority by " + 1000000L);
            }
            serviceReplicationStatus.reducePriority(1000000L, description);
        }
    }

    protected void onActiveFailure() throws InterruptedException, ActiveElectionException {
        this.elect();
    }

    protected void startSplitBrainController() throws RemoteException {
        if (this._splitBrainController != null) {
            return;
        }
        ElectionEntry splitBrainTemplate = this._electTemplate.clone();
        splitBrainTemplate.setState(ActiveElectionState.State.ACTIVE);
        this._splitBrainController = new SplitBrainController(splitBrainTemplate, this);
    }

    public synchronized void terminate() {
        block6: {
            if (this._isTerminated) {
                return;
            }
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.fine("Terminating...");
            }
            try {
                this.changeState(null, ActiveElectionState.State.NONE, false);
            }
            catch (RemoteException ex) {
                if (!this._logger.isLoggable(Level.FINE)) break block6;
                this._logger.fine("Failed to reset current state on " + this.getNamingService().getName());
            }
        }
        if (this._splitBrainController != null) {
            this._splitBrainController.terminate();
        }
        if (this._activeFailureDetector != null) {
            this._activeFailureDetector.terminate();
        }
        this._isTerminated = true;
        this._logger.fine("Terminated");
    }

    public synchronized ActiveElectionState.State getState() {
        return this._currentState;
    }

    public ActiveElectionConfig getConfig() {
        return this._config;
    }

    INamingService getNamingService() {
        return this._namingService;
    }

    IActiveElectionDecisionFilter getElectionFilter() {
        return this._decisionFilter;
    }

    private synchronized void setCurrentState(ActiveElectionState.State currentState) {
        this._currentState = currentState;
    }

    protected synchronized boolean isTerminate() {
        return this._isTerminated;
    }

    public String toString() {
        return "Space instance [" + this._electTemplate.service + "] ";
    }

    public void reelect() throws InterruptedException, ActiveElectionException, RemoteException {
        this.changeState(this.getState(), ActiveElectionState.State.PENDING, true);
        this.elect();
    }

    public ClusterFailureDetector getClusterFailureDetector() {
        return this._clusterFailureDetector;
    }

    SpaceMode getSpaceMode() {
        return ((LusBasedSelectorHandler)this._listener).getSpaceMode();
    }

    private static final class ElectionEntry
    extends ServiceTemplate
    implements Cloneable {
        private static final long serialVersionUID = 1L;
        ActiveElectionState _actState;
        ServiceID _serviceID;
        transient Object service;

        private ElectionEntry(Object service, ServiceTemplate srvTemplate) {
            super(null, null, null);
            this.service = service;
            if (service instanceof ReferentUuid) {
                long mostSignBits = ((ReferentUuid)service).getReferentUuid().getMostSignificantBits();
                long leastSignBits = ((ReferentUuid)service).getReferentUuid().getLeastSignificantBits();
                this._serviceID = new ServiceID(mostSignBits, leastSignBits);
            }
            this._actState = new ActiveElectionState();
            this.attributeSetTemplates = LookupAttributes.add(srvTemplate.attributeSetTemplates, new Entry[]{this._actState});
            this.serviceTypes = srvTemplate.serviceTypes;
        }

        public ElectionEntry clone() {
            try {
                ElectionEntry cloneEntry = (ElectionEntry)super.clone();
                cloneEntry._actState = new ActiveElectionState();
                cloneEntry.attributeSetTemplates = (Entry[])this.attributeSetTemplates.clone();
                for (int i = 0; i < cloneEntry.attributeSetTemplates.length; ++i) {
                    if (!(cloneEntry.attributeSetTemplates[i] instanceof ActiveElectionState)) continue;
                    cloneEntry.attributeSetTemplates[i] = cloneEntry._actState;
                    break;
                }
                return cloneEntry;
            }
            catch (CloneNotSupportedException e) {
                throw new InternalError();
            }
        }

        private Object getService() {
            return this.service;
        }

        private void setState(ActiveElectionState.State state) {
            this._actState.setState(state);
        }

        private ServiceID getServiceID() {
            return this._serviceID;
        }
    }
}

