/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionException;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionManager;
import com.gigaspaces.internal.server.space.recovery.direct_persistency.DirectPersistencyRecoveryException;
import com.gigaspaces.internal.utils.concurrent.GSThread;
import com.j_spaces.core.cluster.startup.FaultDetectionListener;
import java.rmi.RemoteException;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;

@InternalApi
public class ActiveFailureDetector
extends GSThread
implements FaultDetectionListener {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.active-election");
    private final CountDownLatch _onInitialize;
    private final ActiveElectionManager _electionManager;
    private boolean _isTerminated;

    ActiveFailureDetector(ActiveElectionManager electionManager, ServiceItem monitorService) throws RemoteException {
        super("ActiveFailureDetector");
        this.setDaemon(true);
        this._electionManager = electionManager;
        this._onInitialize = new CountDownLatch(1);
        this.start();
        try {
            this._onInitialize.await();
        }
        catch (InterruptedException ie) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, Thread.currentThread().getName() + " interrupted", ie);
            }
            Thread.currentThread().interrupt();
            throw new RemoteException(Thread.currentThread().getName() + " interrupted", ie);
        }
        Object service = monitorService.getService();
        try {
            this._electionManager.getClusterFailureDetector().register(this, monitorService.serviceID, service);
        }
        catch (Exception e) {
            this.terminate();
            String msg = "Failed to register service: " + service.getClass() + " with fault detection manager";
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, msg, e);
            }
            throw new RemoteException(msg, e);
        }
    }

    @Override
    public synchronized void serviceFailure(Object service, Object serviceID) {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.toString() + " active election failure detector identified failure: [" + service + "] serviceID: [" + serviceID + "]. Started to elect new ACTIVE service");
        }
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ActiveFailureDetector activeFailureDetector = this;
            synchronized (activeFailureDetector) {
                block18: {
                    if (!this.isTerminate()) break block18;
                    return;
                }
                this._onInitialize.countDown();
                this.wait();
            }
            this.terminate();
            if (this._electionManager.isSpaceInRecovery()) {
                _logger.info("Detected primary Space failure during recovery");
                return;
            }
            boolean wasErrorMessageLogged = false;
            while (true) {
                try {
                    this._electionManager.onActiveFailure();
                }
                catch (ActiveElectionException e) {
                    if (wasErrorMessageLogged) continue;
                    if (_logger.isLoggable(Level.WARNING)) {
                        _logger.log(Level.WARNING, this.toString() + " could not participate in active election. Election process will continue once the Lookup Service is reconnected", e);
                    }
                    wasErrorMessageLogged = true;
                    continue;
                }
                catch (DirectPersistencyRecoveryException ex) {
                    if (_logger.isLoggable(Level.SEVERE)) {
                        _logger.log(Level.SEVERE, this.toString() + " Direct persistency recovery failure", ex);
                    }
                }
                break;
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        finally {
            this.terminate();
        }
    }

    public synchronized boolean isTerminate() {
        return this._isTerminated;
    }

    public synchronized void terminate() {
        if (this._isTerminated) {
            return;
        }
        this._isTerminated = true;
        if (Thread.currentThread() != this) {
            this.interrupt();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, this.toString() + " active failure detector has terminated");
        }
    }

    public String toString() {
        return this._electionManager.toString();
    }
}

