/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.utils.StringUtils;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;

@InternalApi
public class ServiceReplicationStatus
implements Comparable<ServiceReplicationStatus> {
    public static final long CONSISTENT_REPLICATION_PRIORITY = 0L;
    public static final long LOWEST_REPLICATION_PRIORITY = Long.MAX_VALUE;
    public static final long INACTIVE_FACTOR = 1000L;
    public static final long INCONSISTENT_WITH_MIRROR_FACTOR = 1000000000L;
    public static final long INCONSISTENT_WITH_SPACE_FACTOR = 1000000L;
    public static ServiceReplicationStatus UNKNOWN = new ServiceReplicationStatus(Long.MAX_VALUE, "Unknown replication status");
    public static ServiceReplicationStatus UNREACHABLE_TARGET = new ServiceReplicationStatus(Long.MAX_VALUE, "Unreachable target");
    public long _priority;
    public final LinkedList<String> _description = new LinkedList();
    private Set<String> _replicationTargetsNames;
    private long _processId;

    public ServiceReplicationStatus() {
        this._priority = 0L;
    }

    public ServiceReplicationStatus(long priority, String serviceReplicationStatus) {
        this._priority = priority;
        this._description.add(serviceReplicationStatus);
    }

    public void reducePriority(long reductionFactor, String description) {
        this._description.addLast(description);
        this._priority = Integer.MAX_VALUE - reductionFactor < this._priority ? Integer.MAX_VALUE : (this._priority += reductionFactor);
    }

    public long getPriority() {
        return this._priority;
    }

    public String getDescription() {
        if (this._description.isEmpty()) {
            return "Consistent replication state";
        }
        return this._description.toString();
    }

    @Override
    public int compareTo(ServiceReplicationStatus o) {
        if (this._priority == o.getPriority()) {
            return 0;
        }
        return this._priority > o.getPriority() ? 1 : -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("replicationStatus=[inconsistency rank=" + this._priority + " (closer to 0 is more consistent)]:" + StringUtils.NEW_LINE);
        if (this._description.isEmpty()) {
            sb.append(" - Consistent replication state");
        } else {
            for (int i = 0; i < this._description.size(); ++i) {
                String description = this._description.get(i);
                sb.append(" - " + description);
                if (i >= this._description.size() - 1) continue;
                sb.append(StringUtils.NEW_LINE);
            }
        }
        return sb.toString();
    }

    public boolean containsReplicationTarget(String targetMemberName) {
        return this._replicationTargetsNames != null && this._replicationTargetsNames.contains(targetMemberName);
    }

    public void addReplicationTargetName(String targetMemberName) {
        if (this._replicationTargetsNames == null) {
            this._replicationTargetsNames = new HashSet<String>();
        }
        this._replicationTargetsNames.add(targetMemberName);
    }

    public void setProcessId(long processId) {
        this._processId = processId;
    }

    public long getProcessId() {
        return this._processId;
    }
}

