/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionManager;
import com.gigaspaces.cluster.activeelection.core.ActiveElectionState;
import com.gigaspaces.internal.naming.INamingService;
import com.gigaspaces.internal.utils.concurrent.GSThreadFactory;
import com.j_spaces.core.IJSpace;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.lookup.LookupCache;
import net.jini.lookup.ServiceDiscoveryEvent;
import net.jini.lookup.ServiceDiscoveryListener;

@InternalApi
public class SplitBrainController {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.active-election");
    private static final int EXTRA_BACKUP_RESOLUTION_RETRIES = Integer.getInteger("com.gs.cluster.extra_backup_space_resolution_retries", 15);
    private ScheduledExecutorService threadPool = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new GSThreadFactory("GS-SplitBrainExecutor", true));
    private static final String THREAD_EXECUTOR_NAME = "GS-SplitBrainExecutor";
    private final ActiveElectionManager _electManager;
    private final LookupCache _namingCache;
    private boolean _isTerminated;
    private final ServiceTemplate _template;

    SplitBrainController(ServiceTemplate template, ActiveElectionManager electManager) throws RemoteException {
        this._electManager = electManager;
        this._template = template;
        INamingService namingSrv = electManager.getNamingService();
        this._namingCache = namingSrv.notify(template, null, new ActiveDiscovery());
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString() + " started.");
        }
    }

    private synchronized boolean isTerminated() {
        return this._isTerminated;
    }

    public synchronized void terminate() {
        if (this.isTerminated()) {
            return;
        }
        this._namingCache.terminate();
        this._isTerminated = true;
        if (this.threadPool != null) {
            this.threadPool.shutdown();
        }
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine(this.toString() + " terminated.");
        }
    }

    static final boolean isSplitBrainExecutor(Thread thread) {
        return thread.getName().equals(THREAD_EXECUTOR_NAME);
    }

    public String toString() {
        return "Split-Brain Controller";
    }

    private void removeUnavailableServices(List<ServiceItem> services) {
        Iterator<ServiceItem> iterator = services.iterator();
        while (iterator.hasNext()) {
            ServiceItem serviceItem = iterator.next();
            IJSpace primarySpace = (IJSpace)serviceItem.getService();
            try {
                primarySpace.ping();
            }
            catch (RemoteException e) {
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("Primary space [] is not available, ignoring it in election process.");
                }
                iterator.remove();
            }
        }
    }

    private final class ActiveDiscovery
    implements ServiceDiscoveryListener {
        private ActiveDiscovery() {
        }

        @Override
        public synchronized void serviceAdded(ServiceDiscoveryEvent event) {
            if (SplitBrainController.this.isTerminated()) {
                return;
            }
            this.takeActionOnExtraBackup(event);
            this.takeActionOnSplitBrain(event);
        }

        private void takeActionOnSplitBrain(ServiceDiscoveryEvent event) {
            List<ServiceItem> splitActives = this.getActiveServices();
            if (splitActives.size() < 2) {
                return;
            }
            try {
                SplitBrainController.this.threadPool.schedule(new Runnable(){

                    @Override
                    public void run() {
                        block4: {
                            if (SplitBrainController.this.isTerminated()) {
                                return;
                            }
                            try {
                                List splitActives = ActiveDiscovery.this.getActiveServices();
                                if (splitActives.size() < 2) {
                                    return;
                                }
                                SplitBrainController.this._electManager.onSplitBrain(splitActives);
                            }
                            catch (Exception ex) {
                                if (!_logger.isLoggable(Level.SEVERE)) break block4;
                                _logger.log(Level.SEVERE, this.toString() + " Failed to resolve split-brain.", ex);
                            }
                        }
                    }
                }, 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        private void takeActionOnExtraBackup(final ServiceDiscoveryEvent event) {
            if (SplitBrainController.this._electManager.getState().equals((Object)ActiveElectionState.State.ACTIVE)) {
                return;
            }
            try {
                SplitBrainController.this.threadPool.scheduleWithFixedDelay(new Runnable(){
                    private int retries = SplitBrainController.access$500();

                    @Override
                    public void run() {
                        if (SplitBrainController.this.isTerminated()) {
                            throw new CancellationException();
                        }
                        ServiceItem activeServiceItem = event.getPostEventServiceItem();
                        if (this.retries-- == 0) {
                            if (_logger.isLoggable(Level.WARNING)) {
                                _logger.warning("Exhausted " + EXTRA_BACKUP_RESOLUTION_RETRIES + " retry attempts to resolve discovery of extra-backup Space using: [" + activeServiceItem + "]");
                            }
                            throw new CancellationException();
                        }
                        SplitBrainController.this._electManager.onActiveDiscoveryCheckExtraBackup(activeServiceItem);
                    }
                }, 5L, 10L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }

        @Override
        public void serviceChanged(ServiceDiscoveryEvent event) {
        }

        @Override
        public void serviceRemoved(ServiceDiscoveryEvent event) {
        }

        private List<ServiceItem> getActiveServices() {
            ServiceItem[] activeSrv = SplitBrainController.this._electManager.getNamingService().lookup(SplitBrainController.this._template, Integer.MAX_VALUE, null);
            List<ServiceItem> splitActives = ActiveElectionManager.trimServices(activeSrv);
            SplitBrainController.this.removeUnavailableServices(splitActives);
            return splitActives;
        }
    }
}

