/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.activeelection.core;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ICandidateEntry;
import com.gigaspaces.cluster.activeelection.core.ServiceReplicationStatus;
import com.gigaspaces.internal.utils.StringUtils;
import com.j_spaces.lookup.entry.HostName;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceItem;

@InternalApi
public class SplitBrainServiceEntry
implements Comparable<SplitBrainServiceEntry> {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.space.active-election");
    private final ServiceItem _service;
    private final ServiceReplicationStatus _replicationStatus;
    private final ICandidateEntry _electionPriorityEntry;

    public SplitBrainServiceEntry(ServiceItem service, ServiceReplicationStatus replicationStatus, ICandidateEntry electionPriorityEntry) {
        this._service = service;
        this._replicationStatus = replicationStatus;
        this._electionPriorityEntry = electionPriorityEntry;
    }

    public ICandidateEntry getElectionPriorityEntry() {
        return this._electionPriorityEntry;
    }

    public ServiceItem getService() {
        return this._service;
    }

    public ServiceReplicationStatus getReplicationStatus() {
        return this._replicationStatus;
    }

    @Override
    public int compareTo(SplitBrainServiceEntry o) {
        int replicationStatusCompare = this._replicationStatus.compareTo(o.getReplicationStatus());
        if (replicationStatusCompare != 0) {
            return replicationStatusCompare;
        }
        return this._electionPriorityEntry.compareTo(o.getElectionPriorityEntry());
    }

    public String toString() {
        StringBuilder logBuf = new StringBuilder();
        String host = HostName.getHostNameFrom(this._service.attributeSets);
        Object service = this._service.getService();
        logBuf.append("[").append(service).append("] space");
        if (host != null) {
            logBuf.append(" on [").append(host).append("] machine");
        }
        logBuf.append(" [pid=");
        logBuf.append(this._replicationStatus.getProcessId());
        logBuf.append("]");
        logBuf.append(StringUtils.NEW_LINE);
        logBuf.append("Service properties = ").append(StringUtils.NEW_LINE);
        logBuf.append("{");
        logBuf.append(this._replicationStatus).append(StringUtils.NEW_LINE);
        logBuf.append("}");
        return logBuf.toString();
    }
}

