/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.loadbalance;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.JSpaceState;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.kernel.JSpaceUtilities;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

@InternalApi
public class LoadBalancingPolicy
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 2L;
    public static final int DEFAULT_BROADCAST_THREADPOOL_MIN_SIZE = 4;
    public static final int DEFAULT_BROADCAST_THREADPOOL_MAX_SIZE = 64;
    public String m_GroupName;
    public List<String> loadBalanceGroupMembersNames;
    public List<SpaceURL> loadBalanceGroupMembersURLs;
    public boolean m_ApplyOwnership;
    public boolean m_DisableParallelScattering;
    public int m_broadcastThreadpoolMinSize = 4;
    public int m_broadcastThreadpoolMaxSize = 64;
    public LoadBalancingPolicyDescription m_WriteOperationsPolicy;
    public LoadBalancingPolicyDescription m_ReadOperationsPolicy;
    public LoadBalancingPolicyDescription m_TakeOperationsPolicy;
    public LoadBalancingPolicyDescription m_NotifyOperationsPolicy;
    public LoadBalancingPolicyDescription m_DefaultPolicy;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = this.buildFlags();
        out.writeInt(flags);
        if (this.m_GroupName != null) {
            out.writeObject(this.m_GroupName);
        }
        if (this.loadBalanceGroupMembersNames != null) {
            out.writeInt(this.loadBalanceGroupMembersNames.size());
            for (String s : this.loadBalanceGroupMembersNames) {
                out.writeObject(s);
            }
        }
        if (this.loadBalanceGroupMembersURLs != null) {
            out.writeInt(this.loadBalanceGroupMembersURLs.size());
            for (SpaceURL u : this.loadBalanceGroupMembersURLs) {
                out.writeObject(u);
            }
        }
        if (this.m_broadcastThreadpoolMinSize != 4) {
            out.writeInt(this.m_broadcastThreadpoolMinSize);
        }
        if (this.m_broadcastThreadpoolMinSize != 64) {
            out.writeInt(this.m_broadcastThreadpoolMaxSize);
        }
        if (this.m_WriteOperationsPolicy != null) {
            out.writeObject(this.m_WriteOperationsPolicy);
        }
        if (this.m_ReadOperationsPolicy != null) {
            out.writeObject(this.m_ReadOperationsPolicy);
        }
        if (this.m_TakeOperationsPolicy != null) {
            out.writeObject(this.m_TakeOperationsPolicy);
        }
        if (this.m_NotifyOperationsPolicy != null) {
            out.writeObject(this.m_NotifyOperationsPolicy);
        }
        if (this.m_DefaultPolicy != null) {
            out.writeObject(this.m_DefaultPolicy);
        }
    }

    private int buildFlags() {
        int flags = 0;
        if (this.m_GroupName != null) {
            flags |= 1;
        }
        if (this.loadBalanceGroupMembersNames != null) {
            flags |= 2;
        }
        if (this.loadBalanceGroupMembersURLs != null) {
            flags |= 4;
        }
        if (this.m_ApplyOwnership) {
            flags |= 8;
        }
        if (this.m_DisableParallelScattering) {
            flags |= 0x10;
        }
        if (this.m_broadcastThreadpoolMinSize != 4) {
            flags |= 0x20;
        }
        if (this.m_broadcastThreadpoolMinSize != 64) {
            flags |= 0x40;
        }
        if (this.m_WriteOperationsPolicy != null) {
            flags |= 0x80;
        }
        if (this.m_ReadOperationsPolicy != null) {
            flags |= 0x100;
        }
        if (this.m_TakeOperationsPolicy != null) {
            flags |= 0x200;
        }
        if (this.m_NotifyOperationsPolicy != null) {
            flags |= 0x400;
        }
        if (this.m_DefaultPolicy != null) {
            flags |= 0x800;
        }
        return flags;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        int size;
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            this.m_GroupName = (String)in.readObject();
        }
        if ((flags & 2) != 0) {
            size = in.readInt();
            this.loadBalanceGroupMembersNames = new ArrayList<String>(size);
            for (i = 0; i < size; ++i) {
                this.loadBalanceGroupMembersNames.add((String)in.readObject());
            }
        }
        if ((flags & 4) != 0) {
            size = in.readInt();
            this.loadBalanceGroupMembersURLs = new ArrayList<SpaceURL>(size);
            for (i = 0; i < size; ++i) {
                this.loadBalanceGroupMembersURLs.add((SpaceURL)in.readObject());
            }
        }
        this.m_ApplyOwnership = (flags & 8) != 0;
        this.m_DisableParallelScattering = (flags & 0x10) != 0;
        this.m_broadcastThreadpoolMinSize = (flags & 0x20) != 0 ? in.readInt() : 4;
        this.m_broadcastThreadpoolMaxSize = (flags & 0x40) != 0 ? in.readInt() : 64;
        if ((flags & 0x80) != 0) {
            this.m_WriteOperationsPolicy = (LoadBalancingPolicyDescription)in.readObject();
        }
        if ((flags & 0x100) != 0) {
            this.m_ReadOperationsPolicy = (LoadBalancingPolicyDescription)in.readObject();
        }
        if ((flags & 0x200) != 0) {
            this.m_TakeOperationsPolicy = (LoadBalancingPolicyDescription)in.readObject();
        }
        if ((flags & 0x400) != 0) {
            this.m_NotifyOperationsPolicy = (LoadBalancingPolicyDescription)in.readObject();
        }
        if ((flags & 0x800) != 0) {
            this.m_DefaultPolicy = (LoadBalancingPolicyDescription)in.readObject();
        }
    }

    public List<SpaceURL> getRecoverableTargets(String clusterName, String myMemberName, List<String> excludeTargets) {
        LinkedList<SpaceURL> recoverableTargets = new LinkedList<SpaceURL>();
        boolean foundJini = false;
        for (int i = 0; i < this.loadBalanceGroupMembersNames.size(); ++i) {
            SpaceURL remoteSpaceURL;
            String memberName = this.loadBalanceGroupMembersNames.get(i);
            if (memberName.equals(myMemberName) || excludeTargets.contains(memberName) || (remoteSpaceURL = this.loadBalanceGroupMembersURLs.get(i).clone()) == null) continue;
            if (remoteSpaceURL.isJiniProtocol()) {
                if (!foundJini) {
                    SpaceURL anySpaceURL = remoteSpaceURL.clone();
                    anySpaceURL.setPropertiesPrefix("jini:", "*", "*", "*");
                    anySpaceURL.setProperty("clustername", clusterName);
                    anySpaceURL.setProperty("state", JSpaceState.convertToString(1));
                    recoverableTargets.addFirst(anySpaceURL);
                    foundJini = true;
                }
                if (remoteSpaceURL.getProperty("host") == null || "*".equals(remoteSpaceURL.getProperty("host"))) continue;
                remoteSpaceURL.setProperty("clustername", clusterName);
                remoteSpaceURL.setProperty("state", JSpaceState.convertToString(1));
                recoverableTargets.add(remoteSpaceURL);
                continue;
            }
            recoverableTargets.add(remoteSpaceURL);
        }
        return recoverableTargets;
    }

    public String toString() {
        return "\n------------ LoadBalancing Policy ---------\nGroup Name -\t" + this.m_GroupName + '\n' + "Load Balancing Group Members Name -\t" + this.loadBalanceGroupMembersNames + '\n' + "Load Balancing Group Members URL -\t" + this.loadBalanceGroupMembersURLs + '\n' + "Is apply ownership -\t" + this.m_ApplyOwnership + '\n' + "Is disable Parallel Scattering -\t" + this.m_DisableParallelScattering + '\n' + "Broadcast Thread Pool Min Size -\t" + this.m_broadcastThreadpoolMinSize + '\n' + "Broadcast Thread Pool Max Size -\t" + this.m_broadcastThreadpoolMaxSize + '\n' + '\n' + "Write Operations Policy -\t" + this.m_WriteOperationsPolicy + '\n' + '\n' + "Read Operations Policy -\t" + this.m_ReadOperationsPolicy + '\n' + '\n' + "Take Operations Policy -\t" + this.m_TakeOperationsPolicy + '\n' + '\n' + "Notify Operations Policy -\t" + this.m_NotifyOperationsPolicy + '\n' + '\n' + "Default Policy -\t" + this.m_DefaultPolicy + '\n';
    }

    public static enum BroadcastCondition {
        ROUTING_INDEX_IS_NULL("routing-index-is-null"),
        ALWAYS("always"),
        NEVER("never"),
        IF_NULL_VALUES("broadcast-if-null-values"),
        UNCONDITIONAL("unconditional"),
        DISABLED("broadcast-disabled");

        private final String _description;

        private BroadcastCondition(String description) {
            this._description = description;
        }

        public boolean isBroadcastNever() {
            return this == NEVER || this == DISABLED;
        }

        public String getDescription() {
            return this._description;
        }

        public static BroadcastCondition getBroadcastConditionValue(String val) {
            if ("never".equals(val)) {
                return NEVER;
            }
            if ("always".equals(val)) {
                return ALWAYS;
            }
            if ("routing-index-is-null".equals(val)) {
                return ROUTING_INDEX_IS_NULL;
            }
            if ("broadcast-disabled".equals(val)) {
                return DISABLED;
            }
            if ("unconditional".equals(val)) {
                return UNCONDITIONAL;
            }
            if ("broadcast-if-null-values".equals(val)) {
                return IF_NULL_VALUES;
            }
            return ROUTING_INDEX_IS_NULL;
        }
    }

    public static class LoadBalancingPolicyDescription
    implements Serializable,
    Externalizable {
        private static final long serialVersionUID = 2L;
        public String m_PolicyType;
        public Properties m_Properties;
        private BroadcastCondition m_BroadcastCondition;
        private String _broadcastConditionDescription;

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            byte flags = 0;
            if (this.m_PolicyType != null) {
                flags = (byte)(flags | 1);
            }
            if (this.m_Properties != null) {
                flags = (byte)(flags | 2);
            }
            if (this.m_BroadcastCondition != null) {
                flags = (byte)(flags | 4);
            }
            if (this._broadcastConditionDescription != null) {
                flags = (byte)(flags | 8);
            }
            out.writeByte(flags);
            if (this.m_PolicyType != null) {
                out.writeUTF(this.m_PolicyType);
            }
            if (this.m_Properties != null) {
                out.writeInt(this.m_Properties.size());
                for (Map.Entry<Object, Object> entry : this.m_Properties.entrySet()) {
                    out.writeUTF((String)entry.getKey());
                    out.writeUTF((String)entry.getValue());
                }
            }
            if (this.m_BroadcastCondition != null) {
                out.writeObject((Object)this.m_BroadcastCondition);
            }
            if (this._broadcastConditionDescription != null) {
                out.writeObject(this._broadcastConditionDescription);
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            byte flags = in.readByte();
            if ((flags & 1) != 0) {
                this.m_PolicyType = in.readUTF();
            }
            if ((flags & 2) != 0) {
                int size = in.readInt();
                this.m_Properties = new Properties();
                for (int i = 0; i < size; ++i) {
                    this.m_Properties.put(in.readUTF(), in.readUTF());
                }
            }
            if ((flags & 4) != 0) {
                this.m_BroadcastCondition = (BroadcastCondition)((Object)in.readObject());
            }
            if ((flags & 8) != 0) {
                this._broadcastConditionDescription = (String)in.readObject();
            }
        }

        public String getBroadcastConditionDescription() {
            return this._broadcastConditionDescription;
        }

        public void setBroadcastConditionDescription(String broadcastConditionDescription) {
            this._broadcastConditionDescription = broadcastConditionDescription;
            this.setBroadcastCondition(BroadcastCondition.getBroadcastConditionValue(this._broadcastConditionDescription));
        }

        public void setBroadcastCondition(BroadcastCondition broadcastCondition) {
            this.m_BroadcastCondition = broadcastCondition;
            if (this._broadcastConditionDescription == null) {
                this._broadcastConditionDescription = broadcastCondition.getDescription();
            }
        }

        public BroadcastCondition getBroadcastCondition() {
            return this.m_BroadcastCondition;
        }

        public String toString() {
            return "\n------------Load Balancing Policy Description---------\nPolicy Type -\t" + this.m_PolicyType + '\n' + "Properties -\t" + JSpaceUtilities.getPropertiesPresentation(this.m_Properties) + '\n' + "Broadcast Condition -\t" + this.getBroadcastConditionDescription() + '\n';
        }

        private static interface BitMap {
            public static final byte POLICY_TYPE = 1;
            public static final byte PROPERTIES = 2;
            public static final byte BROADCAST_CONDITION = 4;
            public static final byte BROADCAST_CONDITION_DESC = 8;
        }
    }

    private static interface BitMap {
        public static final int GROUP_NAME = 1;
        public static final int LOAD_BALANCE_GROUP_MEMBER_NAMES = 2;
        public static final int LOAD_BALANCE_GROUP_MEMBER_URLS = 4;
        public static final int APPLY_OWNERSHIP = 8;
        public static final int DISABLE_PARALLEL_SCATERING = 16;
        public static final int BROADCAST_TP_MIN_SIZE = 32;
        public static final int BROADCAST_TP_MAX_SIZE = 64;
        public static final int WRITE_OP_POLICY = 128;
        public static final int READ_OP_POLICY = 256;
        public static final int TAKE_OP_POLICY = 512;
        public static final int NOTIFY_OP_POLICY = 1024;
        public static final int DEFAULT_OP_POLICY = 2048;
    }
}

