/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication;

import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.RedoLogCapacityExceededPolicy;
import com.j_spaces.core.cluster.ReplicationPolicy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;

public final class MirrorServiceConfig
implements Externalizable {
    private static final long serialVersionUID = 2L;
    private static final Long DEFAULT_MIRROR_REDO_LOG_CAPACITY = null;
    public SpaceURL serviceURL;
    public String memberName;
    public int bulkSize = 100;
    public long intervalMillis = 2000L;
    public int intervalOpers = 100;
    public RedoLogCapacityExceededPolicy onRedoLogCapacityExceeded = ReplicationPolicy.DEFAULT_REDO_LOG_CAPACITY_EXCEEDED;
    public Long maxRedoLogCapacity = DEFAULT_MIRROR_REDO_LOG_CAPACITY;
    public boolean supportsPartialUpdate = false;
    public Set<String> supportedChangeOperations = null;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        byte flags = 0;
        if (this.serviceURL != null) {
            flags = (byte)(flags | 1);
        }
        if (this.memberName != null) {
            flags = (byte)(flags | 2);
        }
        if (this.bulkSize != 500) {
            flags = (byte)(flags | 4);
        }
        if (this.intervalMillis != 3000L) {
            flags = (byte)(flags | 8);
        }
        if (this.intervalOpers != 500) {
            flags = (byte)(flags | 0x10);
        }
        if (this.onRedoLogCapacityExceeded != ReplicationPolicy.DEFAULT_REDO_LOG_CAPACITY_EXCEEDED) {
            flags = (byte)(flags | 0x20);
        }
        if (this.maxRedoLogCapacity != DEFAULT_MIRROR_REDO_LOG_CAPACITY) {
            flags = (byte)(flags | 0x40);
        }
        out.writeByte(flags);
        if (this.serviceURL != null) {
            this.serviceURL.writeExternal(out);
        }
        if (this.memberName != null) {
            out.writeUTF(this.memberName);
        }
        if (this.bulkSize != 500) {
            out.writeInt(this.bulkSize);
        }
        if (this.intervalMillis != 3000L) {
            out.writeLong(this.intervalMillis);
        }
        if (this.intervalOpers != 500) {
            out.writeInt(this.intervalOpers);
        }
        if (this.onRedoLogCapacityExceeded != ReplicationPolicy.DEFAULT_REDO_LOG_CAPACITY_EXCEEDED) {
            out.writeObject((Object)this.onRedoLogCapacityExceeded);
        }
        if (this.maxRedoLogCapacity != DEFAULT_MIRROR_REDO_LOG_CAPACITY) {
            out.writeObject(this.maxRedoLogCapacity);
        }
        out.writeBoolean(this.supportsPartialUpdate);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            boolean supportChange = this.supportedChangeOperations != null;
            out.writeBoolean(supportChange);
            if (supportChange) {
                IOUtils.writeStringSet(out, this.supportedChangeOperations);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte flags = in.readByte();
        if ((flags & 1) != 0) {
            this.serviceURL = new SpaceURL();
            this.serviceURL.readExternal(in);
        }
        if ((flags & 1) != 0) {
            this.memberName = in.readUTF();
        }
        this.bulkSize = (flags & 4) != 0 ? in.readInt() : 500;
        this.intervalMillis = (flags & 8) != 0 ? in.readLong() : 3000L;
        this.intervalOpers = (flags & 0x10) != 0 ? in.readInt() : 500;
        this.onRedoLogCapacityExceeded = (flags & 0x20) != 0 ? (RedoLogCapacityExceededPolicy)((Object)in.readObject()) : ReplicationPolicy.DEFAULT_REDO_LOG_CAPACITY_EXCEEDED;
        this.maxRedoLogCapacity = (flags & 0x40) != 0 ? (Long)in.readObject() : DEFAULT_MIRROR_REDO_LOG_CAPACITY;
        this.supportsPartialUpdate = in.readBoolean();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            boolean supportsChange = in.readBoolean();
            this.supportedChangeOperations = !supportsChange ? null : IOUtils.readStringSet(in);
        }
    }

    public boolean isMirrorTarget(String targetMember) {
        return this.memberName.equals(targetMember);
    }

    public String toString() {
        StringBuilder strBuffer = new StringBuilder("-----------MirrorServiceConfig-------------\n");
        strBuffer.append("Service URL -\t" + this.serviceURL + "\n");
        strBuffer.append("Member Name -\t" + this.memberName + "\n");
        strBuffer.append("Bulk Size -\t" + this.bulkSize + "\n");
        strBuffer.append("Interval Millis -\t" + this.intervalMillis + "\n");
        strBuffer.append("Interval Operations -\t" + this.intervalOpers + "\n");
        strBuffer.append("Max Redo Log Capacity -\t" + this.maxRedoLogCapacity + "\n");
        strBuffer.append("On Redo Log Capacity Exceeded -\t" + (Object)((Object)this.onRedoLogCapacityExceeded) + "\n");
        strBuffer.append("Supports partial update -\t" + this.supportsPartialUpdate + "\n");
        String supportedChangeOperation = this.supportedChangeOperations != null ? this.supportedChangeOperations.toString() : "None";
        strBuffer.append("Supported change Operation -\t" + supportedChangeOperation + "\n");
        return strBuffer.toString();
    }

    private static interface BitMap {
        public static final byte SERVICE_URL = 1;
        public static final byte MEMBER_NAME = 2;
        public static final byte BULK_SIZE = 4;
        public static final byte INTERVAL_MILLIS = 8;
        public static final byte INTERVAL_OPERS = 16;
        public static final byte ON_REDO_LOG_CAPACITY_EXCEEDED = 32;
        public static final byte MAX_REDO_LOG_CAPACITY = 64;
    }
}

