/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.client.ResourceCapacityExceededException;

@InternalApi
public class RedoLogCapacityExceededException
extends ResourceCapacityExceededException {
    private final String targetName;
    private final String spaceName;
    private static final long serialVersionUID = 1L;

    public RedoLogCapacityExceededException(long redoLogSize, long maxBacklogAllowed, String targetName, String spaceName) {
        super("This operation cannot be performed because it needs to be replicated and the current replication backlog capacity reached [" + redoLogSize + "/" + maxBacklogAllowed + "], backlog is kept for replication channel from " + spaceName + " to target " + targetName + ". Retry the operation once the backlog size is reduced");
        this.targetName = targetName;
        this.spaceName = spaceName;
    }

    public RedoLogCapacityExceededException(String message, String targetName, String spaceName) {
        super(message);
        this.targetName = targetName;
        this.spaceName = spaceName;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public String getSpaceName() {
        return this.spaceName;
    }
}

