/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.activeelection.ISpaceComponentsHandler;
import com.gigaspaces.cluster.activeelection.SpaceComponentsInitializeException;
import com.gigaspaces.cluster.replication.ReplicationFilterWrapper;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.SpaceURL;
import com.j_spaces.core.cluster.ReplicationFilterProvider;
import com.j_spaces.core.cluster.ReplicationPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationFilterManager
implements ISpaceComponentsHandler {
    private ReplicationFilterWrapper _inputFilterWrapper;
    private ReplicationFilterWrapper _outputWrapper;
    private IJSpace _space;
    protected ReplicationPolicy _replicationPolicy;
    private ReplicationPolicy.ReplicationPolicyDescription _replicationDescription;
    private boolean _startIfPrimaryOnly;
    private boolean _shutdownSpaceOnInitFailure;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");

    public ReplicationFilterManager(ReplicationPolicy replPolicy, SpaceURL spaceURL, IJSpace spaceProxy) {
        this._replicationPolicy = replPolicy;
        this._replicationDescription = replPolicy.m_ReplMemberPolicyDescTable.get(replPolicy.m_OwnMemberName);
        this._space = spaceProxy;
        if (spaceURL != null) {
            ReplicationFilterProvider replicationFilterProvider = (ReplicationFilterProvider)spaceURL.getCustomProperties().get("replication-filter-provider");
            if (replicationFilterProvider != null) {
                this.buildFilters(replicationFilterProvider);
            } else {
                this.buildFilters(this._replicationDescription);
            }
        } else {
            this.buildFilters(this._replicationDescription);
        }
    }

    private void buildFilters(ReplicationFilterProvider replicationFilterProvider) {
        _logger.log(Level.FINE, "Using replication filters injected using replication filter provider, will not use definitions in cluster schema");
        if (replicationFilterProvider.getInputFilter() != null) {
            this._inputFilterWrapper = new ReplicationFilterWrapper(replicationFilterProvider.getInputFilter());
        }
        if (replicationFilterProvider.getOutputFilter() != null) {
            this._outputWrapper = replicationFilterProvider.getInputFilter() == replicationFilterProvider.getOutputFilter() ? this._inputFilterWrapper : new ReplicationFilterWrapper(replicationFilterProvider.getOutputFilter());
        }
        this._startIfPrimaryOnly = !replicationFilterProvider.isActiveWhenBackup();
        this._shutdownSpaceOnInitFailure = replicationFilterProvider.isShutdownSpaceOnInitFailure();
    }

    private void buildFilters(ReplicationPolicy.ReplicationPolicyDescription replicationPolicyDescription) {
        if (replicationPolicyDescription.inputReplicationFilterClassName != null) {
            this._inputFilterWrapper = new ReplicationFilterWrapper(this._replicationDescription.inputReplicationFilterClassName);
        }
        if (this._replicationDescription.outputReplicationFilterClassName != null) {
            this._outputWrapper = this.isInputFilterEnabled() && this._inputFilterWrapper.getClassName().equals(this._replicationDescription.outputReplicationFilterClassName) ? this._inputFilterWrapper : new ReplicationFilterWrapper(this._replicationDescription.outputReplicationFilterClassName);
        }
        this._startIfPrimaryOnly = !this._replicationDescription.activeWhenBackup;
        this._shutdownSpaceOnInitFailure = this._replicationDescription.shutdownSpaceOnInitFailure;
    }

    public void close() {
        if (this.isInputFilterEnabled()) {
            this._inputFilterWrapper.close();
        }
        if (this.isOutputFilterEnabled()) {
            this._outputWrapper.close();
        }
    }

    public boolean isOutputFilterEnabled() {
        return this._outputWrapper != null;
    }

    public boolean isInputFilterEnabled() {
        return this._inputFilterWrapper != null;
    }

    @Override
    public void initComponents(boolean primaryOnly) throws SpaceComponentsInitializeException {
        if (primaryOnly != this._startIfPrimaryOnly) {
            return;
        }
        if (this.isInputFilterEnabled()) {
            this.initFilter(this._inputFilterWrapper, this._replicationDescription.inputReplicationFilterParamUrl);
        }
        if (this.isOutputFilterEnabled()) {
            this.initFilter(this._outputWrapper, this._replicationDescription.outputReplicationFilterParamUrl);
        }
    }

    private void initFilter(ReplicationFilterWrapper filterHolder, String url) throws SpaceComponentsInitializeException {
        block2: {
            try {
                filterHolder.init(this._space, url, this._replicationPolicy);
            }
            catch (RuntimeException re) {
                if (!this._shutdownSpaceOnInitFailure) break block2;
                throw new SpaceComponentsInitializeException("Failed to initialize replication filter - " + filterHolder.getClassName(), re);
            }
        }
    }

    @Override
    public void startComponents(boolean primaryOnly) {
    }

    @Override
    public boolean isRecoverySupported() {
        return true;
    }

    @Override
    public void close(boolean primaryOnly) {
        if (primaryOnly != this._startIfPrimaryOnly) {
            return;
        }
        this.close();
    }

    public ReplicationFilterWrapper getInputFilter() {
        return this._inputFilterWrapper;
    }

    public ReplicationFilterWrapper getOutputFilter() {
        return this._outputWrapper;
    }
}

