/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.cluster.IReplicationFilter;
import com.j_spaces.core.cluster.IReplicationFilterEntry;
import com.j_spaces.core.cluster.ReplicationPolicy;
import com.j_spaces.kernel.ClassLoaderHelper;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class ReplicationFilterWrapper {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.replication");
    private final IReplicationFilter _filter;
    private volatile State _state = State.UNINITIALIZED;

    public ReplicationFilterWrapper(String className) {
        try {
            this._filter = (IReplicationFilter)ClassLoaderHelper.loadClass(className).newInstance();
        }
        catch (Exception e) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to add replication filter " + className + ": newInstance() aborted: ", e);
            }
            throw new RuntimeException("Failed to add ReplicationFilter " + className + ": newInstance() aborted", e);
        }
    }

    public ReplicationFilterWrapper(IReplicationFilter filter) {
        this._filter = filter;
    }

    public void init(IJSpace space, String paramUrl, ReplicationPolicy replicationPolicy) {
        if (this.isInitialized()) {
            return;
        }
        try {
            this._filter.init(space, paramUrl, replicationPolicy);
            this._state = State.INITIALIZED;
        }
        catch (RuntimeException re) {
            if (_logger.isLoggable(Level.SEVERE)) {
                _logger.log(Level.SEVERE, "Failed to initialize replication filter " + this.getClassName(), re);
            }
            this.close();
            throw re;
        }
    }

    public void process(int direction, IReplicationFilterEntry replicationFilterEntry, String remoteSpaceMemberName) {
        if (!this.isInitialized()) {
            return;
        }
        this._filter.process(direction, replicationFilterEntry, remoteSpaceMemberName);
    }

    public void close() {
        block4: {
            if (!this.isInitialized()) {
                return;
            }
            try {
                this._filter.close();
                if (_logger.isLoggable(Level.FINE)) {
                    _logger.fine("ReplicationFilterManager: Filter: " + this.getClassName() + " closed successfully.");
                }
                this._state = State.CLOSED;
            }
            catch (Exception e) {
                if (!_logger.isLoggable(Level.FINE)) break block4;
                _logger.log(Level.FINE, "ReplicationFilterManager:  Failed to close " + this.getClassName(), e);
            }
        }
    }

    public boolean isInitialized() {
        return this._state == State.INITIALIZED;
    }

    public String getClassName() {
        return this._filter.getClass().getName();
    }

    public String toString() {
        return "ReplicationFilterWrapper [_filter=" + this._filter + ", _state=" + (Object)((Object)this._state) + "]";
    }

    private static enum State {
        UNINITIALIZED,
        INITIALIZED,
        CLOSED;

    }
}

