/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication;

import com.gigaspaces.api.InternalApi;
import com.j_spaces.core.cluster.ReplicationPolicy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class ReplicationTransmissionPolicy
implements Cloneable,
Externalizable {
    private static final long serialVersionUID = 2L;
    public static final char REPLICATION_TRANSMISSION_OPERATION_WRITE = 'W';
    public static final char REPLICATION_TRANSMISSION_OPERATION_REMOVE = 'T';
    public static final char REPLICATION_TRANSMISSION_OPERATION_NOTIFY = 'N';
    public static final String OPER_WRITE = "write";
    public static final String OPER_TAKE = "take";
    public static final String OPER_NOTIFY = "notify";
    public String m_SourceSpace;
    public String m_TargetSpace;
    public String m_RepTransmissionOperations;
    public boolean m_SyncOnCommit;
    public boolean m_DisableTransmission;
    private boolean _isSyncReplication = false;
    private boolean _isOneWayReplication = false;
    private boolean _mirrorConnector;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int flags = 0;
        if (this.m_RepTransmissionOperations != null) {
            flags |= 1;
        }
        if (this.m_SyncOnCommit) {
            flags |= 2;
        }
        if (this.m_DisableTransmission) {
            flags |= 4;
        }
        if (this._isSyncReplication) {
            flags |= 8;
        }
        if (this._isOneWayReplication) {
            flags |= 0x10;
        }
        if (this._mirrorConnector) {
            flags |= 0x40;
        }
        if (this.m_SourceSpace != null) {
            flags |= 0x80;
        }
        if (this.m_TargetSpace != null) {
            flags |= 0x100;
        }
        out.writeInt(flags);
        if (this.m_RepTransmissionOperations != null) {
            out.writeUTF(this.m_RepTransmissionOperations);
        }
        if (this.m_SourceSpace != null) {
            out.writeUTF(this.m_SourceSpace);
        }
        if (this.m_TargetSpace != null) {
            out.writeUTF(this.m_TargetSpace);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int flags = in.readInt();
        if ((flags & 1) != 0) {
            this.m_RepTransmissionOperations = in.readUTF();
        }
        if ((flags & 0x80) != 0) {
            this.m_SourceSpace = in.readUTF();
        }
        if ((flags & 0x100) != 0) {
            this.m_TargetSpace = in.readUTF();
        }
        this.m_SyncOnCommit = (flags & 2) != 0;
        this.m_DisableTransmission = (flags & 4) != 0;
        this._isSyncReplication = (flags & 8) != 0;
        this._isOneWayReplication = (flags & 0x10) != 0;
        this._mirrorConnector = (flags & 0x40) != 0;
    }

    public ReplicationTransmissionPolicy() {
    }

    public ReplicationTransmissionPolicy(String source, String target, String operations, boolean SyncOnCommit, boolean disableTransmission) {
        this.m_SourceSpace = source;
        this.m_TargetSpace = target;
        this.m_RepTransmissionOperations = operations;
        this.m_SyncOnCommit = SyncOnCommit;
        this.m_DisableTransmission = disableTransmission;
    }

    public ReplicationTransmissionPolicy(String source, String target, String operations, boolean SyncOnCommit, String communicationMode, boolean disableTransmission) {
        this.m_SourceSpace = source;
        this.m_TargetSpace = target;
        this.m_RepTransmissionOperations = operations;
        this.m_SyncOnCommit = SyncOnCommit;
        this.m_DisableTransmission = disableTransmission;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public ReplicationTransmissionPolicy(String source, String target) {
        this.m_SourceSpace = source;
        this.m_TargetSpace = target;
    }

    public ReplicationTransmissionPolicy(String source, String target, ReplicationPolicy replPolicy) {
        this.m_SourceSpace = source;
        this.m_TargetSpace = target;
        this.m_SyncOnCommit = replPolicy.m_SyncOnCommit;
        if (replPolicy.getMirrorServiceConfig() != null && replPolicy.getMirrorServiceConfig().isMirrorTarget(target)) {
            this.setupMirror(target, replPolicy);
        } else {
            this.setOneWayReplication(replPolicy.isOneWayReplication);
            ReplicationPolicy.ReplicationPolicyDescription replicationPolicyDescription = replPolicy.m_ReplMemberPolicyDescTable.get(source);
            ReplicationTransmissionPolicy transmissionMatrix = replicationPolicyDescription.getTargetTransmissionMatrix(target);
            if (transmissionMatrix == null) {
                this.setSyncReplication(replPolicy.m_IsSyncReplicationEnabled);
            } else {
                this.setSyncReplication(transmissionMatrix.isSyncReplication());
            }
        }
    }

    private void setupMirror(String targetName, ReplicationPolicy replPolicy) {
        this.setSyncReplication(false);
        this.setMirrorConnector(true);
    }

    public String getSourceName() {
        return this.m_SourceSpace;
    }

    public String getTargetName() {
        return this.m_TargetSpace;
    }

    public void setOneWayReplication(boolean isOneWay) {
        this._isOneWayReplication = isOneWay;
    }

    public boolean isOneWayReplication() {
        return this._isOneWayReplication;
    }

    public boolean isSyncReplication() {
        return this._isSyncReplication;
    }

    public void setSyncReplication(boolean isSyncReplication) {
        this._isSyncReplication = isSyncReplication;
    }

    public void setMirrorConnector(boolean isMirrorConnector) {
        this._mirrorConnector = isMirrorConnector;
    }

    public boolean isMirrorConnector() {
        return this._mirrorConnector;
    }

    public String toString() {
        String str = "[ Source: " + this.m_SourceSpace + ", Target: " + this.m_TargetSpace + ", RepTransmissionOperations: " + this.m_RepTransmissionOperations + ", SyncOnCommit: " + this.m_SyncOnCommit + ", DisableTransmission: " + this.m_DisableTransmission + ", isSyncReplication: " + this._isSyncReplication + " ]";
        return str;
    }

    private static interface BitMap {
        public static final int TRANSMISSION_OPERATIONS = 1;
        public static final int SYNC_ON_COMMIT = 2;
        public static final int DISABLE_TRANSMISSION = 4;
        public static final int SYNC_REPLICATION = 8;
        public static final int ONE_WAY_REPLICATION = 16;
        public static final int MIRROR_CONNECTOR = 64;
        public static final int SOURCE_SPACE = 128;
        public static final int TARGET_SPACE = 256;
    }
}

