/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication.async.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationStatistics;
import com.gigaspaces.metrics.LongCounter;
import com.gigaspaces.metrics.MetricRegistrator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class MirrorOperationStatisticsImpl
implements Externalizable,
MirrorOperationStatistics {
    private static final long serialVersionUID = 1L;
    private final LongCounter _operationCount = new LongCounter();
    private final LongCounter _successfulOperationCount = new LongCounter();
    private final LongCounter _failedOperationCount = new LongCounter();
    private final LongCounter _discardedOperationCount = new LongCounter();

    @Override
    public long getOperationCount() {
        return this._operationCount.getCount();
    }

    @Override
    public long getSuccessfulOperationCount() {
        return this._successfulOperationCount.getCount();
    }

    @Override
    public long getFailedOperationCount() {
        return this._failedOperationCount.getCount();
    }

    @Override
    public long getDiscardedOperationCount() {
        return this._discardedOperationCount.getCount();
    }

    @Override
    public long getInProgressOperationCount() {
        long completedOperationCount = this.getSuccessfulOperationCount() + this.getFailedOperationCount() + this.getDiscardedOperationCount();
        return this.getOperationCount() - completedOperationCount;
    }

    public void incrementOperationCount() {
        this._operationCount.inc();
    }

    public void incrementSuccessfulOperationCount() {
        this._successfulOperationCount.inc();
    }

    public void incrementFailedOperationCount() {
        this._failedOperationCount.inc();
    }

    public void incrementDiscardedOperationCount() {
        this._discardedOperationCount.inc();
    }

    public void add(MirrorOperationStatistics operationStatistics) {
        this._successfulOperationCount.inc(operationStatistics.getSuccessfulOperationCount());
        this._failedOperationCount.inc(operationStatistics.getFailedOperationCount());
        this._discardedOperationCount.inc(operationStatistics.getDiscardedOperationCount());
        this._operationCount.inc(operationStatistics.getOperationCount());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("  MirrorOperationStatistics\n    [\n        operationCount=");
        builder.append(this._operationCount);
        builder.append(", \n        successfulOperationCount=");
        builder.append(this._successfulOperationCount);
        builder.append(", \n        discardedOperationCount=");
        builder.append(this._discardedOperationCount);
        builder.append(", \n        failedOperationCount=");
        builder.append(this._failedOperationCount);
        builder.append(", \n        inProgressOperationCount=");
        builder.append(this.getInProgressOperationCount());
        builder.append("\n    ]");
        return builder.toString();
    }

    public void register(MetricRegistrator registrator, String prefix) {
        registrator.register(prefix + "total", this._operationCount);
        registrator.register(prefix + "successful", this._successfulOperationCount);
        registrator.register(prefix + "failed", this._operationCount);
        registrator.register(prefix + "discarded", this._operationCount);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this._operationCount.getCount());
        out.writeLong(this._successfulOperationCount.getCount());
        out.writeLong(this._failedOperationCount.getCount());
        out.writeLong(this._discardedOperationCount.getCount());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._operationCount.inc(in.readLong());
        this._successfulOperationCount.inc(in.readLong());
        this._failedOperationCount.inc(in.readLong());
        this._discardedOperationCount.inc(in.readLong());
    }
}

