/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication.async.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.AbstractMirrorOperations;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationStatisticsImpl;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperations;
import com.gigaspaces.datasource.BulkItem;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.metrics.MetricRegistrator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

@InternalApi
public class MirrorOperationsImpl
extends AbstractMirrorOperations
implements MirrorOperations,
Externalizable {
    private static final long serialVersionUID = 1L;
    private MirrorOperationStatisticsImpl _writeOperationStatistics = new MirrorOperationStatisticsImpl();
    private MirrorOperationStatisticsImpl _updateOperationStatistics = new MirrorOperationStatisticsImpl();
    private MirrorOperationStatisticsImpl _removeOperationStatistics = new MirrorOperationStatisticsImpl();
    private MirrorOperationStatisticsImpl _changeOperationStatistics = new MirrorOperationStatisticsImpl();

    @Override
    public MirrorOperationStatisticsImpl getWriteOperationStatistics() {
        return this._writeOperationStatistics;
    }

    @Override
    public MirrorOperationStatisticsImpl getUpdateOperationStatistics() {
        return this._updateOperationStatistics;
    }

    @Override
    public MirrorOperationStatisticsImpl getRemoveOperationStatistics() {
        return this._removeOperationStatistics;
    }

    @Override
    public MirrorOperationStatisticsImpl getChangeOperationStatistics() {
        return this._changeOperationStatistics;
    }

    public void addOperationCount(List<BulkItem> bulkItems) {
        for (BulkItem item : bulkItems) {
            this.getOperationStatistics(item.getOperation()).incrementOperationCount();
        }
    }

    public void addSuccessfulOperationCount(List<BulkItem> bulkItems) {
        for (BulkItem item : bulkItems) {
            this.getOperationStatistics(item.getOperation()).incrementSuccessfulOperationCount();
        }
    }

    public void addFailedOperationCount(List<BulkItem> bulkItems) {
        for (BulkItem item : bulkItems) {
            this.getOperationStatistics(item.getOperation()).incrementFailedOperationCount();
        }
    }

    public void register(MetricRegistrator metricRegistrator) {
        this._writeOperationStatistics.register(metricRegistrator, "write-operations-");
        this._updateOperationStatistics.register(metricRegistrator, "update-operations-");
        this._removeOperationStatistics.register(metricRegistrator, "remove-operations-");
        this._changeOperationStatistics.register(metricRegistrator, "change-operations-");
    }

    private MirrorOperationStatisticsImpl getOperationStatistics(short itemCode) {
        switch (itemCode) {
            case 3: {
                return this.getWriteOperationStatistics();
            }
            case 2: 
            case 4: {
                return this.getUpdateOperationStatistics();
            }
            case 1: {
                return this.getRemoveOperationStatistics();
            }
            case 5: {
                return this.getChangeOperationStatistics();
            }
        }
        throw new IllegalArgumentException("Unsupported item code: " + itemCode);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this._writeOperationStatistics);
        out.writeObject(this._updateOperationStatistics);
        out.writeObject(this._removeOperationStatistics);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            out.writeObject(this._changeOperationStatistics);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._writeOperationStatistics = (MirrorOperationStatisticsImpl)in.readObject();
        this._updateOperationStatistics = (MirrorOperationStatisticsImpl)in.readObject();
        this._removeOperationStatistics = (MirrorOperationStatisticsImpl)in.readObject();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v9_5_0)) {
            this._changeOperationStatistics = (MirrorOperationStatisticsImpl)in.readObject();
        }
    }
}

