/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication.async.mirror;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.cluster.replication.async.mirror.AbstractMirrorOperations;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationStatistics;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationStatisticsImpl;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperations;
import com.gigaspaces.cluster.replication.async.mirror.MirrorOperationsImpl;
import com.gigaspaces.cluster.replication.async.mirror.MirrorStatistics;
import com.gigaspaces.internal.cluster.node.handlers.IReplicationInOperationsStatistics;
import com.gigaspaces.internal.server.space.SpaceImpl;
import com.gigaspaces.metrics.DummyMetricRegistrator;
import com.gigaspaces.metrics.MetricRegistrator;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@InternalApi
public class MirrorStatisticsImpl
extends AbstractMirrorOperations
implements MirrorStatistics,
Externalizable,
IReplicationInOperationsStatistics<MirrorOperations> {
    private static final long serialVersionUID = 1L;
    private ConcurrentHashMap<String, MirrorOperationsImpl> _channelStatistics = new ConcurrentHashMap();
    private transient MetricRegistrator _metricRegistrator = DummyMetricRegistrator.get();

    @Override
    public String toString() {
        return "MirrorStatistics [\n operationCount=" + this.getOperationCount() + ",\n successfulOperationCount=" + this.getSuccessfulOperationCount() + ", \n discardedOperationCount=" + this.getDiscardedOperationCount() + ", \n failedOperationCount=" + this.getFailedOperationCount() + ", \n inProgressOperationCount=" + this.getInProgressOperationCount() + ",\n writeOperationStatistics=" + this.getWriteOperationStatistics() + ", updateOperationStatistics=" + this.getUpdateOperationStatistics() + ", removeOperationStatistics=" + this.getRemoveOperationStatistics() + ", changeOperationStatistics=" + this.getChangeOperationStatistics() + ", channelStatistics=" + this.getAllSourceChannelStatistics() + "]";
    }

    public void setMetricRegistrator(MetricRegistrator metricRegistrator) {
        this._metricRegistrator = metricRegistrator.extend("mirror");
    }

    @Override
    public Map<String, ? extends MirrorOperations> getAllSourceChannelStatistics() {
        return this._channelStatistics;
    }

    @Override
    public MirrorOperations getSourceChannelStatistics(String channelName) {
        MirrorOperationsImpl channelStat = this._channelStatistics.get(channelName);
        if (channelStat == null) {
            channelStat = new MirrorOperationsImpl();
            channelStat.register(this._metricRegistrator.extend(SpaceImpl.extractInstanceId(channelName)));
            this._channelStatistics.putIfAbsent(channelName, channelStat);
        }
        return channelStat;
    }

    @Override
    public MirrorOperationStatistics getWriteOperationStatistics() {
        MirrorOperationStatisticsImpl stat = new MirrorOperationStatisticsImpl();
        for (AbstractMirrorOperations abstractMirrorOperations : this._channelStatistics.values()) {
            stat.add(abstractMirrorOperations.getWriteOperationStatistics());
        }
        return stat;
    }

    @Override
    public MirrorOperationStatistics getUpdateOperationStatistics() {
        MirrorOperationStatisticsImpl stat = new MirrorOperationStatisticsImpl();
        for (AbstractMirrorOperations abstractMirrorOperations : this._channelStatistics.values()) {
            stat.add(abstractMirrorOperations.getUpdateOperationStatistics());
        }
        return stat;
    }

    @Override
    public MirrorOperationStatistics getRemoveOperationStatistics() {
        MirrorOperationStatisticsImpl stat = new MirrorOperationStatisticsImpl();
        for (AbstractMirrorOperations abstractMirrorOperations : this._channelStatistics.values()) {
            stat.add(abstractMirrorOperations.getRemoveOperationStatistics());
        }
        return stat;
    }

    @Override
    public MirrorOperationStatistics getChangeOperationStatistics() {
        MirrorOperationStatisticsImpl stat = new MirrorOperationStatisticsImpl();
        for (AbstractMirrorOperations abstractMirrorOperations : this._channelStatistics.values()) {
            stat.add(abstractMirrorOperations.getChangeOperationStatistics());
        }
        return stat;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(new HashMap<String, MirrorOperationsImpl>(this._channelStatistics));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this._channelStatistics = new ConcurrentHashMap((HashMap)in.readObject());
    }
}

