/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cluster.replication.gateway.sync;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.cluster.node.IReplicationInBatchContext;
import com.gigaspaces.internal.cluster.node.handlers.ITransactionInContext;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.SynchronizationSourceDetails;
import com.gigaspaces.sync.TransactionData;
import com.gigaspaces.transaction.ConsolidatedDistributedTransactionMetaData;
import com.gigaspaces.transaction.TransactionParticipantMetaData;

@InternalApi
public class TransactionDataImpl
implements TransactionData,
SynchronizationSourceDetails {
    private final ITransactionInContext _transactionContext;
    private final IReplicationInBatchContext _batchContext;

    public TransactionDataImpl(IReplicationInBatchContext batchContext, ITransactionInContext transactionContext) {
        this._batchContext = batchContext;
        this._transactionContext = transactionContext;
    }

    @Override
    public boolean isConsolidated() {
        return !this._transactionContext.getMetaData().isUnconsoliated();
    }

    @Override
    public TransactionParticipantMetaData getTransactionParticipantMetaData() {
        return this._transactionContext.getMetaData();
    }

    @Override
    public ConsolidatedDistributedTransactionMetaData getConsolidatedDistributedTransactionMetaData() {
        if (!this.isConsolidated()) {
            throw new IllegalStateException("Cannot get consolidated distributed transaction meta data for an unconsolidated transaction");
        }
        return this._transactionContext.getMetaData();
    }

    @Override
    public DataSyncOperation[] getTransactionParticipantDataItems() {
        DataSyncOperation[] operations = new DataSyncOperation[this._batchContext.getPendingContext().size()];
        return this._batchContext.getPendingContext().toArray(operations);
    }

    @Override
    public SynchronizationSourceDetails getSourceDetails() {
        return this;
    }

    @Override
    public String getName() {
        return this._batchContext.getSourceLookupName();
    }
}

